% Example for the use of obdBCS on synthetic data.
% Before running this function the OMP package of Ron Rubinstein
% (Computer Science Department Technion) must be installed. It can be
% downloaded from: http://www.cs.technion.ac.il/~ronrubin/software.html

close all 
clear all 
clc

%% Parameters
n=64;          % number of measurements 
L=2;            % number of bases
m=L*n;       % length of the signals
M=2;
k=6;            % sparsity level
N=2000;      % number of signals

%the measurement matrix
A1=orth(randn(n));
A2=orth(randn(n));
A=[A1,A2];

%% Creating the signals and measurements
S=zeros(m,N);  %the sparse matrix
for i=1:N
    p=randperm(m);
    S(p(1:k),i)=randn(k,1);
end

%the basis
P=orth(randn(n/M));
for i=2:(M*L)
    P= blkdiag(P,orth(randn(n/M)));
end

X=P*S;    % the signals
B=A*X;    % the measurements

   
%% ODB-BCS
[Sest,Pest]=obdBCS(A,B,k,M);
Xest=Pest*Sest;
%error calculation
for j=1:N
        err(j)=norm(X(:,j)-Xest(:,j))/norm(X(:,j))*100;
end
errXobd=mean(err(:))

figure
subplot(2,1,1)
imshow(X(:,1:min(N,100)),[]);
subplot(2,1,2)
imshow(Xest(:,1:min(N,100)),[]);

figure
plot(1:m,X(:,1),1:m,Xest(:,1),'-.')
legend('Real Signal','Recovered Signal')
