% Example for the use of obdBCSsep on synthetic data.

close all 
clear all 
clc

%% Parameters
n=64;          % number of measurements 
L=2;            % number of bases
m=L*n;       % length of the signals
M=2;
kb=2;            % sparsity level
N=3000;      % number of signals

%the measurement matrix
A1=orth(randn(n));
A2=orth(randn(n));
A=[A1,A2];

%% Creating the signals and measurements
S1=zeros(n/M,N);
S2=zeros(n/M,N);
S3=zeros(n/M,N);
S4=zeros(n/M,N);
for i=1:N
    p=randperm(n/M);
    S1(p(1:kb),i)=randn(kb,1);
    p=randperm(n/M);
    S2(p(1:kb),i)=randn(kb,1);
    p=randperm(n/M);
    S3(p(1:kb),i)=randn(kb,1);
    p=randperm(n/M);
    S4(p(1:kb),i)=randn(kb,1);
end
S=[S1;S2;S3;S4];

%the basis
P=orth(randn(n/M));
for i=2:(M*L)
    P= blkdiag(P,orth(randn(n/M)));
end

X=P*S;    % the signals
B=A*X;    % the measurements

   
%% ODB-BCS
[Sest,Pest]=obdBCSsep(A,B,kb,M);
Xest=Pest*Sest;
%error calculation
for j=1:N
        err(j)=norm(X(:,j)-Xest(:,j))/norm(X(:,j))*100;
end
errXobd=mean(err(:))

figure
subplot(2,1,1)
imshow(X(:,1:min(N,100)),[]);
subplot(2,1,2)
imshow(Xest(:,1:min(N,100)),[]);

figure
plot(1:m,X(:,1),1:m,Xest(:,1),'-.')
legend('Real Signal','Recovered Signal')
