%BMBox - Implementation of the BM-based sparse signal recovery
%
%Tomer Faktor
%Department of Electrical Engineering
%Technion -- Israel Institute of Technology
%tomerfa@tx.technion.ac.il
%August 2011
%
%Joint pursuit and model estimation:
%   BM_denoising - joint MAP pursuit and model estimation for the BM-based model.  
%
%Pursuit:
%   OMP                            - OMP for a general dictionary.
%   unitary_OMP                    - OMP for a unitary dictionary and gaussian noise.
%   BM_MAP_OMP                     - OMP-like approximation of MAP for the 
%                                    BM-based model. 
%   BM_MAP_Gibbs_sampler           - approximate MAP for the BM-based model via 
%                                    Gibbs sampling. 
%   BM_unitary_MAP_Gibbs_sampler   - approximate MAP for the BM-based model and
%                                    a unitary dictionary via Gibbs sampling.
%   BM_MAP_THR                     - thresholding-like approximation of MAP for the
%                                    BM-based model. 
%   BM_unitary_MAP_message_passing - exact MAP for the BM-based model and a 
%                                    unitary dictionary via message passing.
%   BM_MMSE_rand_OMP               - random OMP-like approximation of MMSE for the 
%                                    BM-based model.
%
%Learning of the Boltzmann parameters:
%   MPL_Boltzmann_SESOP - learning the Boltzmann parameters by MPL via SESOP. 
%   estimate_W_banded   - banded approximation of the interaction matrix. 
%
%Auxiliary functions:
%   BM_generate_samples  - Gibbs sampling from the BM distribution.
%   oracle_formula       - oracle formula of the representation coefficients 
%                          given the signal and the sparsity pattern.  
%   compute_clique_props - auxiliary function for BM_unitary_MAP_message_passing.
%   compute_messages     - auxiliary function for BM_unitary_MAP_message_passing.
%   compute_PL_props     - auxiliary function for MPL_Boltzmann_SESOP.
%   support_dist         - distance between two sparsity patterns.
%
%Demonstrations:
%   test_BM_unitary_pursuit   - synthetic tests of pursuit methods for the 
%                               BM-based model and a unitary dictionary. 
%   test_BM_redundant_pursuit - synthetic tests of pursuit methods for the 
%                               BM-based model and a redundant dictionary. 
%   test_BM_learning          - synthetic tests of learning the Boltzmann parameters. 
%   test_BM_denoising_patches - test BM denoising on image patches.
%
%References:
%   [1] T. Faktor, Y. C. Eldar, and M. Elad, "Exploiting statistical 
%       dependencies in sparse representations for signal recovery", 
%       submitted to IEEE Trans. Signal Processing. 
%   [2] T. Faktor, Y. C. Eldar, and M. Elad, "Denoising of image patches 
%       via sparse representations with learned statistical dependencies", 
%       in ICASSP, Prague, Czech Republic, May 2011.
%