function [m_forward,m_backward] = compute_messages(clique_potentials,S_clique)
%compute_messages computes the messages for finding the most probable configuration 
%in the case of a Boltzmann machine corresponding to a banded interaction matrix.
% =====================================================================================
% Input:
% clique_potentials - the values of the log-potential function for each clique and for 
% all possible assignments for the clique nodes.
% S_clique - all possible assignments for the clique nodes
% =====================================================================================
% Output:
% m_forward - messages from clique C_i to clique C_{i+1} for i=1,...,k
% m_backward - messages from clique C_i to clique C_{i-1} for i=k+2,...,n-L
% =====================================================================================
% Tomer Faktor
% Department of Electrical Engineering
% Technion, Haifa 32000 Israel
% tomerfa@tx.technion.ac.il
%
% August 2011
% =====================================================================================
L=size(S_clique,1)-1;
n=length(clique_potentials)+L;
k=floor((n-L-1)/2);
m_forward=zeros(n-L,2^L);
for i=1:k
    v=clique_potentials{i}+repmat(m_forward(i,:),1,2);
    m_forward(i+1,:)=max(v(S_clique(1,:)==1),v(S_clique(1,:)==-1));
end
m_backward=zeros(n-L,2^L);
for i=n-L:-1:k+2
    v=clique_potentials{i}+reshape(repmat(m_backward(i,:),2,1),1,2^(L+1));
    m_backward(i-1,:)=max(v(S_clique(end,:)==1),v(S_clique(end,:)==-1));
end