function [X_oracle] = unitary_oracle_formula(Y,var_e,model_params,S)
% unitary_oracle_formula computes the oracle formula of the representation coefficients
% given the signal and the sparsity pattern for a unitary dictionary.
% =====================================================================================
% Input:
% Y is an n-by-N matrix consisting of N noisy signals. 
% var_e is the variance of the gaussian distribution of the additive noise.
% model_params - parameters for the stochastic model. Required fields:
% model_params.dictionary - a matrix of size n-by-m consisting of the dictionary atoms.
% The dictionary should be square and unitary.
% model_params.variances - a vector of size m-by-1 consisting of the variances of the 
% gaussian distributions of the nonzero representation coefficients.
% S is an m-by-N matrix consisting of N sparsity patterns.
% =====================================================================================
% Output:
% X_oracle is an m-by-N matrix consisting the restored representation vectors.
% =====================================================================================
% Tomer Faktor
% Department of Electrical Engineering
% Technion, Haifa 32000 Israel
% tomerfa@tx.technion.ac.il
%
% August 2011
% =====================================================================================
% Check input parameters
[n,N]=size(Y);
A=model_params.dictionary;
G=A'*A;
X_oracle=[];
if size(A,2)~=n
    display('Invalid input - the dictionary should be square')
    return;
elseif sum(sum(abs(G-eye(n))>1e-10))>0
    display('Invalid input - the dictionary should be unitary')
    return;
end
var_x=model_params.variances;
% Compute oracle formula
c2=var_x./(var_x+var_e); % shrinkage factors
X_oracle=0.5*(S+1).*repmat(c2(:),1,N).*(A'*Y);