function [S] = BM_generate_samples(N,W,b,num_rounds)
%BM_generate_samples - Gibbs sampling from the BM distribution
% BM - Boltzmann Machine
% =====================================================================================
% Input:
% N - number of samples from the BM distributions. 
% W,b - the Boltzmann parameters: an interaction matrix of size m-by-m and 
% a bias vector of size m-by-1.
% num_rounds - number of rounds for the Gibbs sampler.
% =====================================================================================
% Output:
% S is an m-by-N matrix consisting of the samples.
% =====================================================================================
% Tomer Faktor
% Department of Electrical Engineering
% Technion, Haifa 32000 Israel
% tomerfa@tx.technion.ac.il
%
% August 2011
% =====================================================================================
m=numel(b);
jump_size=10000;
Np=ceil(N/jump_size);
hh = waitbar(0,'Sampling from the BM distribution');
for l=1:Np
    if l<Np
        Nl=jump_size;
    else
        Nl=N-(Np-1)*jump_size;
    end
    S_partial=2*(rand(m,Nl)<0.5)-1; % initialize randomly using uniform distribution 
    for k=1:num_rounds
        waitbar((k+(l-1)*num_rounds)/(Np*num_rounds),hh)
        seq_inds=randperm(m);
        for i=1:m
            curr_ind=seq_inds(i);
            Pr=1./(1+exp(2*S_partial(curr_ind,:).*(W(curr_ind,:)*S_partial+repmat(b(curr_ind),1,Nl))));
            cond=rand(1,Nl)<Pr;
            S_partial(curr_ind,:)=S_partial(curr_ind,:).*(1-2*cond);
        end
    end
    S(:,1+(l-1)*jump_size:min(l*jump_size,N))=S_partial;
end
close(hh)