function [clique_potentials,clique_nodes] = compute_clique_props(W,b,S_clique)
%compute_clique_props computes the properties of the cliques corresponding to a banded 
%interaction matrix.
% =====================================================================================
% Input:
% W,b - the Boltzmann parameters: an interaction matrix of size n-by-n and a bias 
% vector of size n-by-1. The interaction matrix should be banded. 
% S_clique - all possible assignments for the clique nodes
% =====================================================================================
% Output:
% clique_potentials - the values of the log-potential function for each clique and for 
% all possible assignments for the clique nodes.
% clique_nodes - the nodes belonging to each clique
% =====================================================================================
% Tomer Faktor
% Department of Electrical Engineering
% Technion, Haifa 32000 Israel
% tomerfa@tx.technion.ac.il
%
% August 2011
% =====================================================================================
n=numel(b);
L=size(S_clique,1)-1;
k=floor((n-L-1)/2);
for i=1:n-L
    clique_nodes{i}=i:i+L;
    if i<=k
        clique_potentials{i}=S_clique(1,:).*(W(i,i+1:i+L)*S_clique(2:end,:)+b(i));
    elseif i>=k+2
        clique_potentials{i}=S_clique(end,:).*(W(i+L,i:i+L-1)*S_clique(1:end-1,:)+b(i+L));
    else
        clique_potentials{i}=(0.5*diag(S_clique'*W(i:i+L,i:i+L)*S_clique)+S_clique'*b(i:i+L))';
    end
end