function [W_hat,inds_bnd] = estimate_W_banded(W0,L)
%estimate_W_banded computes the best banded approximation of order L to a input
%symmetric matrix in terms of its l_1 norm using row and column permutations.
% =====================================================================================
% Input:
% W0 - an m-by-m symmetric matrix
% L - number of nonzero diagonal in the upper triangle of the banded approximation
% =====================================================================================
% Output:
% W_hat - an m-by-m banded matrix of order L which approximates the original matrix 
% inds_bnd - a vector of size m indicating the row and column permutations 
% =====================================================================================
% Tomer Faktor
% Department of Electrical Engineering
% Technion, Haifa 32000 Israel
% tomerfa@tx.technion.ac.il
%
% August 2011
% =====================================================================================
m=size(W0,1);
all_inds=1:m;
[V1,V2]=meshgrid(all_inds,all_inds);
mask=abs(V1-V2)<=L;
E0=compute_energy(W0,mask);
W_prev=W0;
E_prev=E0;
inds_prev=all_inds;
cnt=1;
while 1
    pairs=nchoosek(1:m,2);
    N1=size(pairs,1);
    E1=zeros(1,N1);
    for l=1:N1
           W1=update_W(W_prev,pairs(l,:));
           E1(l)=compute_energy(W1,mask);
    end
    [E_curr,ind_curr]=max(E1);
    W_curr=update_W(W_prev,pairs(ind_curr,:));
    inds_curr=inds_prev;
    inds_curr(pairs(ind_curr,1))=inds_prev(pairs(ind_curr,2));
    inds_curr(pairs(ind_curr,2))=inds_prev(pairs(ind_curr,1));
    if  E_curr<=E_prev || cnt==51
        W_hat=W_prev;
        W_hat(mask==0)=0;
        inds_bnd=inds_prev;
        break;
    else
        W_prev=W_curr;
        E_prev=E_curr;
        inds_prev=inds_curr;
        cnt=cnt+1;
    end
end

%================================================
function E = compute_energy( W,mask)

E=sum(sum(abs(W(mask))));

return;

%================================================
function W1 = update_W( W_prev,pair)

m=size(W_prev,1);
v=ones(m,1);
v(pair)=0;
partial_inds=find(v>0);
W1=W_prev;
W1(pair(1),partial_inds)=W_prev(pair(2),partial_inds);
W1(pair(2),partial_inds)=W_prev(pair(1),partial_inds);
W1(partial_inds,pair(1))=W_prev(partial_inds,pair(2));
W1(partial_inds,pair(2))=W_prev(partial_inds,pair(1));
W1(diag(W1)>0)=0;

return;