function [X_oracle] = oracle_formula(Y,var_e,model_params,S)
%oracle_formula computes the oracle formula of the representation coeffients given the 
%signal and the sparsity pattern. 
% =====================================================================================
% Input:
% Y is an n-by-N matrix consisting of N noisy signals. 
% var_e is the variance of the gaussian distribution of the additive noise.
% model_params - parameters for the stochastic model. Required fields:
% model_params.dictionary - a matrix of size n-by-m consisting of the dictionary atoms.
% model_params.variances - a vector of size m-by-1 consisting of the variances of the 
% gaussian distributions of the nonzero representation coefficients.
% S is an m-by-N matrix consisting of N sparsity patterns.
% =====================================================================================
% Output:
% X_oracle is an m-by-N matrix consisting the restored representation vectors.
% =====================================================================================
% Tomer Faktor
% Department of Electrical Engineering
% Technion, Haifa 32000 Israel
% tomerfa@tx.technion.ac.il
%
% August 2011
% =====================================================================================
N=size(Y,2);
A=model_params.dictionary;
m=size(A,2);
var_x=model_params.variances;
X_oracle=zeros(m,N);
for l=1:N
    x=zeros(m,1);
    y=Y(:,l);
    s=find(S(:,l)==1);
    As=A(:,s);
    Qs=As'*As+diag(var_e./var_x(s));
    x(s)=Qs\(As'*y);
    X_oracle(:,l)=x;
end