function [dist_S] = support_dist(S1,S2)
%support_dist computes the distance between two sparsity patterns. 
%
% [dist_S] = support_dist(S1,S2) computes the distance betwen two sparsity patterns, 
% The distance is a number in the range [0,1]: 
% dist_S=1 indicates that the two supports are identical
% dist_S=0 indicates that the two supports are disjoint 
% =====================================================================================
% Tomer Faktor
% Department of Electrical Engineering
% Technion, Haifa 32000 Israel
% tomerfa@tx.technion.ac.il
%
% August 2011
% =====================================================================================
k1=sum(S1==1);
k2=sum(S2==1);
success_S=sum(S1==1 & S2==1)./max(k1,k2);
success_S(k1==0 & k2==0)=1;
dist_S=mean(1-success_S);