function [X_OMP,S_OMP,k_OMP] = unitary_OMP(Y,sigma_e,A)
%unitary_OMP finds the exact solution to the problem: 
%argmin_x ||x||_0 s.t. ||y-Ax||_2<=epsilon 
%for a unitary dictionary. 
% OMP - Orthogonal Matching Pursuit
% =====================================================================================
% Input:
% Y - an n-by-N matrix consisting of N signals. 
% A - an n-by-m matrix consisting of the dictionary atoms (normalized).
% The dictionary should be square and unitary.
% stop_method,stop_params - variables for the stopping rule.
% =====================================================================================
% Output:
% X_OMP is an n-by-N matrix consisting the restored representation vectors.
% S_OMP is an n-by-N matrix consisting the sparsity patterns.
% k_OMP is a vector of length N consisting the lengths of the recovered supports.
% =====================================================================================
% Tomer Faktor
% Department of Electrical Engineering
% Technion, Haifa 32000 Israel
% tomerfa@tx.technion.ac.il
%
% August 2011
% =====================================================================================
[n,N]=size(Y);
% Check input parameters
G=A'*A;
X_OMP=[];
S_OMP=[];
k_OMP=[];
if size(A,2)~=n
    display('Invalid input - the dictionary should be square')
    return;
elseif sum(sum(abs(G-eye(n))>1e-10))>0
    display('Invalid input - the dictionary should be unitary')
    return;
end
% Estimate the representation coefficients using hard-thresholding
S_OMP=zeros(n,N);
err=1.15*sqrt(n)*sigma_e;
X=A'*Y;
[X_sorted,inds]=sort(X.^2);
inds1=inds+(repmat(1:N,n,1)-1)*n;
R=cumsum(X_sorted);
S_OMP(inds1)=2*(cumsum(sqrt(R)>err)>=1)-1;
k_OMP=sum(S_OMP==1);
X_OMP=0.5*(S_OMP+1).*X;