function [unshifted_estimated_freq, unshifted_estimated_frequencies, estimated_frequencies] = ...
    freq_recovery(isolated_band, fused_channel_sample_freq, fused_channel_offset, ...
                  band_start_freq, band_end_freq, ...
                  do_plots)

bandpass_filter_order = 600;
upsampled_isolated_band = upsample(isolated_band, 3);
upsampled_isolated_band = filtfilt(firls(bandpass_filter_order, ...
                                         [0 1/3 1/3 2/3 2/3 1], ...
                                         [0 0 1 1 0 0]), ...
                                   1, upsampled_isolated_band);
    % TODO: replace this implementation with something actually good!

[upsampled_isolated_band_psd, upsampled_isolated_band_psd_freq_space] = ...
    pwelch(upsampled_isolated_band, [], [], [], fused_channel_sample_freq*3);

if (exist('do_plots', 'var') && do_plots == true)
    figure;
    plot(upsampled_isolated_band_psd_freq_space, db(upsampled_isolated_band_psd, 'power'), 'm');
    title('Upsampled Isolated Band');
    xlabel('Frequency [Hz]');
    ylabel('Magnitude [dB]');
    xlim([upsampled_isolated_band_psd_freq_space(1) upsampled_isolated_band_psd_freq_space(end)]);
end;

upsampled_isolated_band_sample_time = 1/(fused_channel_sample_freq*3);

upsampled_isolated_band_time_space = (0:(length(upsampled_isolated_band)-1))' .* upsampled_isolated_band_sample_time;

[estimated_freq, estimated_frequencies] = ...
    recovery_loop(upsampled_isolated_band, upsampled_isolated_band_time_space, fused_channel_sample_freq-(0.5*(band_start_freq+band_end_freq)-fused_channel_offset));
unshifted_estimated_freq = fused_channel_offset + (fused_channel_sample_freq - estimated_freq);
unshifted_estimated_frequencies = fused_channel_offset + (fused_channel_sample_freq - estimated_frequencies);

if (exist('do_plots', 'var') && do_plots == true)
    figure;
    plot(0:(length(estimated_frequencies)-1), unshifted_estimated_frequencies);
    title('Convergence');
    xlabel('Iterations');
    ylabel('Estimated Frequency');
end;

end
