function [] ...
    = plot_channels(fig, channel_freq_offsets, channels_indices, ...
                    channels_indices_blocked, united_band_indicators, united_indicators_freq_space, united_psds, united_thresholds, ...
                    gui_callback)

channel_block_count = length(channels_indices_blocked);
channels_count = length(channels_indices);

spacing = 0.08;
new_left_pos = spacing;
for i = 1:channel_block_count
    width = (1-spacing*(channel_block_count+1))*length(channels_indices_blocked{i})/channels_count;
    left_pos = new_left_pos;
    axes = subplot('position', [left_pos spacing width 1-2*spacing], 'Parent', fig);
    new_left_pos = left_pos + width + spacing;
    
    [null, channels_to_plot] = intersect(channels_indices, channels_indices_blocked{i});
    
    plot(axes, united_indicators_freq_space{i}, db(united_psds{i}, 'power'), 'm');
    hold(axes, 'on');
    plot(axes, united_indicators_freq_space{i}, united_thresholds{i}, 'k');
    united_band_indicators_display = ones(size(united_band_indicators{i}))*(max(db(united_psds{i}, 'power'))+1);
    united_band_indicators_display(united_band_indicators{i} == 0) = min(db(united_psds{i}, 'power'))-1;
    plot(axes, united_indicators_freq_space{i}, united_band_indicators_display, 'b');
    plot_vertbars(axes, channel_freq_offsets(channels_to_plot), ':k');
%     for j = 1:length(channels_to_plot)
%         annotation(gcf, 'textbox', [left_pos+(j-1)*width/length(channels_to_plot) spacing width/length(channels_to_plot) 1-2*spacing], ...
%             'String', num2str(channels_indices(channels_to_plot(j))), ...
%             'HorizontalAlignment', 'center', ...
%             'VerticalAlignment', 'bottom', ...
%             'FontSize', 20, ...
%             'FitBoxToText', 'off', ...
%             'LineStyle', 'none');
%     end;
    hold(axes, 'off');
    if (i == channel_block_count)
        legend(axes, 'PSD', 'Thresh.', 'Indicator', 'Location', 'South');
    end;
    title(axes, 'Estimated PSD');
    xlabel(axes, 'Frequency [Hz]');
    ylabel(axes, 'Magnitude [dB]');
    xlim(axes, [united_indicators_freq_space{i}(1) united_indicators_freq_space{i}(end)]);

    if (exist('gui_callback', 'var'))
        set(axes, 'ButtonDownFcn', sprintf(gui_callback, i));
    end;
end;

end
