function [band_indicators, threshold] = ...
         band_detector(Pxx, Pxx_freq_space, threshold, do_plot)

if (~exist('threshold', 'var') || isempty(threshold))
    threshold = mean(db(Pxx, 'power'));
end;

band_indicators = (db(Pxx, 'power') >= threshold);

if (exist('do_plot', 'var') && do_plot == 1)
    figure;
    plot(Pxx_freq_space, db(Pxx, 'power'), 'm');
    title('Estimated PSD');
    xlabel('Frequency [Hz]');
    ylabel('Magnitude [dB]');
end;

end
