function [channels_indices_blocked, ...
          united_band_indicators, united_indicators_freq_space, united_psds, united_thresholds] ...
    = block_channels(channel_freq_offsets, channels_indices, psds, thresholds, band_indicators, indicators_freq_space)

channels_indices_diff = diff(channels_indices);
channel_block_count = 1;
channels_indices_blocked{1} = channels_indices(1);
for i = 1:length(channels_indices_diff)
    if (channels_indices_diff(i) == 1)
        channels_indices_blocked{channel_block_count} = union(channels_indices_blocked{channel_block_count}, channels_indices(i+1)); %#ok<*AGROW>
    else
        channel_block_count = channel_block_count+1;
        channels_indices_blocked{channel_block_count} = [];
        channels_indices_blocked{channel_block_count} = union(channels_indices_blocked{channel_block_count}, channels_indices(i+1));
    end;
end;

for i = 1:channel_block_count
    [null, channels_to_plot] = intersect(channels_indices, channels_indices_blocked{i});
    
	united_band_indicators{i} = reshape(band_indicators(:,channels_to_plot), 1, numel(band_indicators(:,channels_to_plot)))';
    united_indicators_freq_space{i} = ...
        reshape(repmat(channel_freq_offsets(:,channels_to_plot), size(indicators_freq_space(:,channels_to_plot), 1), 1) + indicators_freq_space(:,channels_to_plot), ...
                1, numel(indicators_freq_space(:,channels_to_plot)))';
    united_psds{i} = reshape(psds(:,channels_to_plot), 1, numel(psds(:,channels_to_plot)))';
    united_thresholds{i} = ...
        reshape(repmat(thresholds(:,channels_to_plot), size(indicators_freq_space(:,channels_to_plot), 1), 1), ...
                1, numel(indicators_freq_space(:,channels_to_plot)))';
end;

end
