function vd = calc_vd(s, time_space, downconvertion_freq, lpf_order)

if (~exist('lpf_order', 'var') || isempty(lpf_order))
    lpf_order = 300;
end;

%% Quadrature down-convertion - multiplication

vi =  2*cos(2*pi*downconvertion_freq*time_space) .* s;
vq = -2*sin(2*pi*downconvertion_freq*time_space) .* s;

%% Quadrature down-convertion - filtering

downconvertion_fir_coefs = fir1(lpf_order, 1/3);

filtered_vi = filter(downconvertion_fir_coefs, 1, vi);
filtered_vq = filter(downconvertion_fir_coefs, 1, vq);

%% Calculate error signal

vd = diff(filtered_vi) .* filtered_vq(2:end) - diff(filtered_vq) .* filtered_vi(2:end);
    % TODO: consider using an average of the forward diff and backward diff

end
