function [carrier_frequency, estimated_frequencies] = recovery_loop(signal, time_space, initial_estimate, loop_gain, varargin)

sample_time = time_space(2)-time_space(1);
sample_freq = 1/sample_time;

if (~exist('loop_gain', 'var') || isempty(loop_gain))
    loop_gain = 5e6;
end;
maximal_iterations = 100;
minimal_update = 0.001;
estimated_frequencies = NaN*ones(maximal_iterations+1, 1);
if (exist('initial_estimate', 'var') && ~isempty(initial_estimate))
    estimated_frequencies(1) = initial_estimate;
else
    estimated_frequencies(1) = sample_freq/4;
end;
update = inf;

signal_power = norm(signal)^2/length(signal);

iteration = 0;
while (abs(update) > minimal_update && iteration < maximal_iterations)
    iteration = iteration + 1;
    
    error_signal = -mean(calc_vd(signal, time_space, estimated_frequencies(iteration), varargin)) / signal_power;
    update = loop_gain*error_signal;
    estimated_frequencies(iteration+1) = estimated_frequencies(iteration) + update;
end;

carrier_frequency = estimated_frequencies(iteration+1);

end
