function [band_number, band_start_freq, band_end_freq, left_tolerance, right_tolerance] = ...
    get_band_props(indicators_freq_space, band_indicators, freq_location)

band_markers = diff([0; band_indicators; 0]);
band_starts_indices = find(band_markers == 1);
band_stop_indices = find(band_markers == -1)-1;

band_start_freqs = indicators_freq_space(band_starts_indices); %#ok<FNDSB>
band_stop_freqs = indicators_freq_space(band_stop_indices);

band_number = find(band_start_freqs <= freq_location & band_stop_freqs >= freq_location);

band_start_freq = band_start_freqs(band_number);
band_end_freq = band_stop_freqs(band_number);

if (band_number > 1)
    left_tolerance = band_start_freq-band_stop_freqs(band_number-1);
else
    left_tolerance = band_start_freq-indicators_freq_space(1);
end;

if (band_number < length(band_stop_indices))
    right_tolerance = band_start_freqs(band_number+1)-band_end_freq;
else
    right_tolerance = indicators_freq_space(end)-band_end_freq;
end;

end
