function varargout = panel(varargin)
% PANEL M-file for panel.fig
%      PANEL, by itself, creates a new PANEL or raises the existing
%      singleton*.
%
%      H = PANEL returns the handle to a new PANEL or the handle to
%      the existing singleton*.
%
%      PANEL('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in PANEL.M with the given input arguments.
%
%      PANEL('Property','Value',...) creates a new PANEL or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before panel_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to panel_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help panel

% Last Modified by GUIDE v2.5 12-Aug-2009 16:26:34

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @panel_OpeningFcn, ...
                   'gui_OutputFcn',  @panel_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before panel is made visible.
function panel_OpeningFcn(hObject, eventdata, handles, varargin) %#ok<INUSL>
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to panel (see VARARGIN)

h = handles;

% Choose default command line output for panel
h.output = hObject;

if (length(varargin) <= 3)
    h.minimal_band_width = varargin{1}; % [Hz]
    h.minimal_band_spacing = varargin{2}; % [Hz]

    if (length(varargin) >= 3)
        h.noiseless = varargin{3};
    else
        h.noiseless = false;
    end;
    
    set(h.bandDetectButton, 'Enable', 'off');
    set(h.recoveryButton, 'Enable', 'off');
else
    h.channels_indices = varargin{1};
    h.channels = varargin{2};
    h.channels_negative = varargin{3};
    h.channels_positive = varargin{4};
    h.channel_time_space = varargin{5};
    h.raw_channel_sample_freq = varargin{6};
    h.channel_sample_freq = varargin{7};
    h.signal_length = varargin{8};
    h.channel_freq_offsets = varargin{9};

    h.minimal_band_width = varargin{10}; % [Hz]
    h.minimal_band_spacing = varargin{11}; % [Hz]
        
    if (length(varargin) >= 12)
        h.noiseless = varargin{12};
    else
        h.noiseless = false;
    end;
    
    h.actual_band_freqs = [];
    
    set(h.sigGenButton, 'Enable', 'off');
    
    h = InitialDisplaySetup(h);
end;

% Update handles structure
guidata(hObject, h);

% UIWAIT makes panel wait for user response (see UIRESUME)
% uiwait(handles.figure1);


function h = InitialDisplaySetup(h)

window_size = ceil(h.channel_sample_freq/h.minimal_band_width);
overlap_part = 0.5;

for i = 1:size(h.channels, 2)
    if (h.noiseless == true)
        % estimate PSD
        [h.psds(:,i), h.indicators_freq_space(:,i)] = ...
            pwelch(h.channels(:,i), size(h.channels, 1), 0, [], h.channel_sample_freq);
    else
        % estimate PSD
        [h.psds(:,i), h.indicators_freq_space(:,i)] = ...
            pwelch(h.channels(:,i), window_size, floor(overlap_part*window_size), [], h.channel_sample_freq);
    end;
end;

h = BandDetection(h);

h = UpdateAxes(h);

sorted_band_freqs = sort(h.actual_band_freqs);
for i = 1:length(sorted_band_freqs)
    siggen_text{i} = sprintf('Carrier Freq.: %0.5g Hz.', sorted_band_freqs(i)); %#ok<AGROW>
end;

set(h.sigGenText, 'String', siggen_text);


function h = BandDetection(h)

for i = 1:size(h.channels, 2)
    % rough bands detection
    [h.band_indicators(:,i), h.thresholds(i)] = ...
        band_detector(h.psds(:,i), h.indicators_freq_space(:,i));
end;

[h.channels_indices_blocked, h.united_band_indicators, h.united_indicators_freq_space, h.united_psds, h.united_thresholds] ...
    = block_channels(h.channel_freq_offsets, h.channels_indices, h.psds, h.thresholds, h.band_indicators, h.indicators_freq_space);

for channel_block = 1:length(h.united_band_indicators)
    % apply band rules
    h.corrected_united_band_indicators{channel_block} = ...
        apply_band_rules(h.united_band_indicators{channel_block}, h.united_indicators_freq_space{channel_block}, ...
                         h.minimal_band_width, h.minimal_band_spacing);
end;


function h = UpdateAxes(h)

fig = h.plotsPanel;
plot_channels(fig, h.channel_freq_offsets, h.channels_indices, ...
              h.channels_indices_blocked, h.corrected_united_band_indicators, h.united_indicators_freq_space, h.united_psds, h.united_thresholds, ...
              'panel(''axes_ButtonDownFcn'', gcbo, %d, guidata(gcbo))');


% --- Outputs from this function are returned to the command line.
function varargout = panel_OutputFcn(hObject, eventdata, handles)  %#ok<INUSL>
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in recoveryButton.
function recoveryButton_Callback(hObject, eventdata, handles) %#ok<INUSL,DEFNU>
% hObject    handle to recoveryButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

h = handles;

if (isfield(h, 'band_start_freq') && ~isempty(h.band_start_freq))
    [h.isolated_band, h.filter_coefs, h.fused_channel, h.fused_channel_sample_freq, h.fused_channel_offset] = ...
        isolate_channel(h.channels, h.channel_time_space, h.channels_negative, h.channels_positive, ...
                        h.channel_sample_freq, h.channel_freq_offsets, ...
                        h.band_start_freq, h.band_end_freq, h.left_tolerance, h.right_tolerance);

    [h.estimated_freq, h.estimated_frequencies] = ...
        freq_recovery(h.isolated_band, h.fused_channel_sample_freq, h.fused_channel_offset, ...
                      h.band_start_freq, h.band_end_freq);

    h = UpdatePropertiesText(h);
end;

guidata(hObject, h);


% --- Executes on mouse press over axes background.
function axes_ButtonDownFcn(hObject, eventdata, handles) %#ok<DEFNU>
% hObject    handle to axes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

pt = get(hObject,'CurrentPoint');
x = pt(1,1);
y = pt(1,2);

channel_block = eventdata;
freq = x;
threshold = y;

h = handles;

channel_index = find(h.channel_freq_offsets <= freq & h.channel_freq_offsets+h.channel_sample_freq/2 >= freq);
% channel_block = find(cellfun(@(a)(ismember(h.channels_indices(channel_index),a)), h.channels_indices_blocked));

% rough bands detection
[h.band_indicators(:,channel_index), h.thresholds(channel_index)] = ...
    band_detector(h.psds(:,channel_index), h.indicators_freq_space(:,channel_index), threshold);

[h.channels_indices_blocked, h.united_band_indicators, h.united_indicators_freq_space, h.united_psds, h.united_thresholds] ...
    = block_channels(h.channel_freq_offsets, h.channels_indices, h.psds, h.thresholds, h.band_indicators, h.indicators_freq_space);

% apply band rules
h.corrected_united_band_indicators{channel_block} = ...
    apply_band_rules(h.united_band_indicators{channel_block}, h.united_indicators_freq_space{channel_block}, ...
                     h.minimal_band_width, h.minimal_band_spacing);

h = UpdateAxes(h);

[h.band_number, h.band_start_freq, h.band_end_freq, h.left_tolerance, h.right_tolerance] = ...
    get_band_props(h.united_indicators_freq_space{channel_block}, h.corrected_united_band_indicators{channel_block}, freq);
h.estimated_freq = NaN;

h = UpdatePropertiesText(h);

% Update handles structure
guidata(hObject, h);


function h = UpdatePropertiesText(h)

supp_text{1} = sprintf('Freq. Support: [%0.4g,%0.4g] Hz.', h.band_start_freq, h.band_end_freq);
supp_text{2} = sprintf('Freq. Support Middle: %0.5g Hz.', 0.5*(h.band_start_freq+h.band_end_freq));

isolation_text{1} = sprintf('Left Tolerance: %0.3g Hz.', h.left_tolerance);
isolation_text{2} = sprintf('Right Tolerance: %0.3g Hz.', h.right_tolerance);

recovery_text{1} = sprintf('Carrier Frequency: %0.5g Hz.', h.estimated_freq);

set(h.suppText, 'String', supp_text);
set(h.isolationText, 'String', isolation_text);
set(h.recoveryText, 'String', recovery_text);


% --- Executes on button press in bandDetectButton.
function bandDetectButton_Callback(hObject, eventdata, handles) %#ok<INUSL,DEFNU>
% hObject    handle to bandDetectButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

h = handles;

h = BandDetection(h);

h = UpdateAxes(h);

h.band_number = [];
h.band_start_freq = [];
h.band_end_freq = [];
h.left_tolerance = [];
h.right_tolerance = [];
h.estimated_freq = NaN;

h = UpdatePropertiesText(h);

% Update handles structure
guidata(hObject, h);


% --- Executes on button press in sigGenButton.
function sigGenButton_Callback(hObject, eventdata, handles) %#ok<INUSL,DEFNU>
% hObject    handle to sigGenButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

h = handles;

set(h.sigGenButton, 'Enable', 'off');
set(h.bandDetectButton, 'Enable', 'off');
set(h.recoveryButton, 'Enable', 'off');
guidata(hObject, h);

sbr_system;
prepare_channels;

h.channels_indices = channels_indices;
h.channels = channels;
h.channels_negative = channels_negative;
h.channels_positive = channels_positive;
h.channel_time_space = channel_time_space;
h.raw_channel_sample_freq = raw_channel_sample_freq;
h.channel_sample_freq = channel_sample_freq;
h.signal_length = signal_length;
h.channel_freq_offsets = channel_freq_offsets;
h.actual_band_freqs = actual_band_freqs;

h = InitialDisplaySetup(h);

set(h.sigGenButton, 'Enable', 'on');
set(h.bandDetectButton, 'Enable', 'on');
set(h.recoveryButton, 'Enable', 'on');

% Update handles structure
guidata(hObject, h);
