function [band_indicators3, band_indicators2] = ...
    apply_band_rules(band_indicators1, Pxx_freq_space, ...
                     minimal_band_width, minimal_band_spacing, do_plot)

frequency_resolution = Pxx_freq_space(2)-Pxx_freq_space(1);

if (floor(minimal_band_width/frequency_resolution) > 1)
    minimal_width_kernel = strel('arbitrary', ones(floor(minimal_band_width/frequency_resolution), 1));
    band_indicators2 = imdilate(imerode(band_indicators1, minimal_width_kernel), minimal_width_kernel);
else
    band_indicators2 = band_indicators1;
end;

if (floor(minimal_band_spacing/frequency_resolution) > 1)
    minimal_spacing_kernel = strel('arbitrary', ones(floor(minimal_band_spacing/frequency_resolution), 1));
    band_indicators3 = imerode(imdilate(band_indicators2, minimal_spacing_kernel), minimal_spacing_kernel);
else
    band_indicators3 = band_indicators2;
end;

if (exist('do_plot', 'var') && do_plot == true)
    figure;
    hold on;
    plot(Pxx_freq_space, db(Pxx, 'power'), 'm');
    plot(Pxx_freq_space, mean(db(Pxx, 'power')), 'k');
    plot(Pxx_freq_space, 1/4*band_indicators1*max(db(Pxx, 'power')), 'r');
    plot(Pxx_freq_space, 2/4*band_indicators2*max(db(Pxx, 'power')), 'g');
    plot(Pxx_freq_space, 3/4*band_indicators3*max(db(Pxx, 'power')), 'b');
    legend('PSD', 'Thresh.', 'Indicator1', 'Indicator2', 'Indicator3', 'Indicator4');
    hold off;
    xlim([Pxx_freq_space(1) Pxx_freq_space(end)]);
    title('Estimated PSD');
    xlabel('Frequency [Hz]');
    ylabel('Magnitude [dB]');
end;

end
