%% Generate data

sbr_system; % perform MWC simulation, a la Indian guy
prepare_channels; % convert MWC outputs to suitable CFR data

% load sbr_channels; % load data from previous preparation

noiseless = false;

minimal_band_width = 50e6/8; % [Hz]
minimal_band_spacing = 50e6/8; % [Hz]

number_of_most_powerful_bands = 3;

%% Fine support recovery

% PSD Estimation

windowing_resolution_factor = 1;
required_frequency_resolution = min(minimal_band_width, minimal_band_spacing)*windowing_resolution_factor;
window_size = ceil(channel_sample_freq/required_frequency_resolution);
overlap_part = 0.5;

for i = 1:size(channels, 2)
    if (noiseless == true)
        % estimate PSD
        [psds(:,i), indicators_freq_space(:,i)] = ...
            pwelch(channels(:,i), size(channels, 1), 0, [], channel_sample_freq); %#ok<SAGROW>
    else
        % estimate PSD
        [psds(:,i), indicators_freq_space(:,i)] = ...
            pwelch(channels(:,i), window_size, floor(overlap_part*window_size), [], channel_sample_freq); %#ok<SAGROW>
    end;
end;

% Support detection

thresholds = zeros(size(channel_freq_offsets));
band_indicators = zeros(size(psds));
for i = 1:size(channels, 2)
    % rough bands detection
    [band_indicators(:,i), thresholds(i)] = ...
        band_detector(psds(:,i), indicators_freq_space(:,i));
end;

% block adjacent slices to groups
[channels_indices_blocked, united_band_indicators, united_indicators_freq_space, united_psds, united_thresholds] ...
    = block_channels(channel_freq_offsets, channels_indices, psds, thresholds, band_indicators, indicators_freq_space);

corrected_united_band_indicators = cell(size(united_band_indicators));
for channel_block = 1:length(united_band_indicators) % iterate over slice groups
    % apply band rules
    corrected_united_band_indicators{channel_block} = ...
        apply_band_rules(united_band_indicators{channel_block}, united_indicators_freq_space{channel_block}, ...
                         minimal_band_width, minimal_band_spacing);
end;

fig = figure;
plot_channels(fig, channel_freq_offsets, channels_indices, ...
              channels_indices_blocked, corrected_united_band_indicators, united_indicators_freq_space, united_psds, united_thresholds);

%% Band isolation and carrier frequency recovery

all_band_start_freqs = [];
all_band_stop_freqs = [];
all_left_tolerances = [];
all_right_tolerances = [];
all_band_powers = [];
for i = 1:length(corrected_united_band_indicators) % iterate over slice groups
    
    % band edge detection
    indicators_freq_space_i = united_indicators_freq_space{i};
    psds_i = united_psds{i};
    
    band_markers = diff([0; corrected_united_band_indicators{i}; 0]);
    band_starts_indices = find(band_markers == 1);
    band_stop_indices = find(band_markers == -1)-1;
    
    band_start_freqs = indicators_freq_space_i(band_starts_indices);
    band_stop_freqs = indicators_freq_space_i(band_stop_indices);
    
	left_tolerances = [band_start_freqs(1)-indicators_freq_space_i(1); band_start_freqs(2:end)-band_stop_freqs(1:end-1)];
    right_tolerances = [band_start_freqs(2:end)-band_stop_freqs(1:end-1); indicators_freq_space_i(end)-band_stop_freqs(end)];
    
    band_powers = zeros(size(band_starts_indices));
    for l = 1:length(band_starts_indices)
        band_powers(l) = sum(psds_i(band_starts_indices(l):band_stop_indices(l)));
    end;
    
    all_band_start_freqs = [all_band_start_freqs; band_start_freqs]; %#ok<AGROW>
    all_band_stop_freqs  = [all_band_stop_freqs ; band_stop_freqs]; %#ok<AGROW>
    all_left_tolerances  = [all_left_tolerances ; left_tolerances]; %#ok<AGROW>
    all_right_tolerances = [all_right_tolerances; right_tolerances]; %#ok<AGROW>
    all_band_powers      = [all_band_powers     ; band_powers]; %#ok<AGROW>

end;

[sorted_all_band_powers, all_band_powers_sort_indices] = sort(all_band_powers, 'descend');
strongest_band_indices = all_band_powers_sort_indices(1:min(length(all_band_powers_sort_indices),number_of_most_powerful_bands));

recovered_freqs = zeros(size(strongest_band_indices));
for i = 1:length(strongest_band_indices) % iterate over slice groups
    
    j = strongest_band_indices(i);

    % band isolation
    [isolated_band, filter_coefs, fused_channel, fused_channel_sample_freq, fused_channel_offset] = ...
        isolate_channel(channels, channel_time_space, channels_negative, channels_positive, ...
                        channel_sample_freq, channel_freq_offsets, ...
                        all_band_start_freqs(j), all_band_stop_freqs(j), all_left_tolerances(j), all_right_tolerances(j), ...
                        false);

    % carrier frequency recovery
    [recovered_freqs(i), freq_recovery_convergence(:,i)] = ...
        freq_recovery(isolated_band, fused_channel_sample_freq, fused_channel_offset, ...
                      all_band_start_freqs(j), all_band_stop_freqs(j), ...
                      false); %#ok<SAGROW>
    
end;

recovered_freqs %#ok<NOPTS>
actual_band_freqs = actual_band_freqs.' %#ok<NOPTS>
