function [fused_channel, fused_channel_sample_freq] = ...
    fuse_two_channels(channel_sample_freq, channel_time_space, ...
                      left_channel_negative, left_channel_positive, ...
                      right_channel_negative, right_channel_positive)

fused_channel_sample_freq = 2*channel_sample_freq;
fused_channel_time_space = channel_time_space(1) + (1/fused_channel_sample_freq) .* (0:(2*length(channel_time_space)-1))';

left_channel_negative = interpft(left_channel_negative, 4*length(left_channel_negative));
left_channel_positive = interpft(left_channel_positive, 4*length(left_channel_positive));
right_channel_negative = interpft(right_channel_negative, 4*length(right_channel_negative));
right_channel_positive = interpft(right_channel_positive, 4*length(right_channel_positive));

fused_channel = right_channel_negative .* exp(-1i.*2.*pi.*channel_sample_freq.*3./4.*fused_channel_time_space) + ...
                right_channel_positive .* exp(+1i.*2.*pi.*channel_sample_freq.*3./4.*fused_channel_time_space) + ...
                left_channel_negative .* exp(-1i.*2.*pi.*channel_sample_freq./4.*fused_channel_time_space) + ...
                left_channel_positive .* exp(+1i.*2.*pi.*channel_sample_freq./4.*fused_channel_time_space);
%{
fused_channel = right_channel_negative .* exp(-1i.*2.*pi.*channel_sample_freq.*3./4.*fused_channel_time_space) + ...
                right_channel_positive .* exp(+1i.*2.*pi.*channel_sample_freq.*3./4.*fused_channel_time_space);
%}

fused_channel = real(fused_channel);

end
