function x = FienupFFT( b, x_init, GS )
a = .5;

m = length(b);
n = length(x_init);
X = sqrt( max(0,b) );
z = [ x_init; zeros(m-n,1) ];
res = 1e10;
for itr = 2:1e4
    Z  = fft( z, m );
    Zp = X .* exp( 1i*angle(Z) );
    zp = ifft( Zp );
    z(1:n)  = zp(1:n);
    z(n+1:m) = z(n+1:m) - a*zp(n+1:m);
    
    if rem(itr,1000)==0
        fprintf( 'itr %d: %f\n', itr, ...
            norm( b - abs(fft(z(1:n),m)).^2 )^2 );
    end
    res(itr) = norm( b - abs(fft(z(1:n),m)).^2 )^2;
    if abs( res(itr)-res(itr-1)) < 1e-10
        fprintf( 'itr %d: %f\n', itr, ...
            norm( b - abs(fft(z(1:n),m)).^2 )^2 );
        break
    end
end

if GS==1
for itr = 1e4+1:2e4
    Z  = fft( z, m );
    Zp = X .* exp( 1i*angle(Z) );
    zp = ifft( Zp );
    z(1:n)  = zp(1:n);
    z(n+1:m) = 0;
    
    if rem(itr,1000)==0
        fprintf( 'itr %d: %f\n', itr, ...
            norm( b - abs(fft(z(1:n),m)).^2 )^2 );
    end
    res(itr) = norm( b - abs(fft(z(1:n),m)).^2 )^2;
    if abs( res(itr)-res(itr-1)) < 1e-5
        fprintf( 'itr %d: %f\n', itr, ...
            norm( b - abs(fft(z(1:n),m)).^2 )^2 );
        break
    end
end
end
x = z(1:n);

% figure
% loglog(res)