function x_min = MPE(x)
% minimum phase equivalent
% use x to construct an auto-correlation
% then run spectral factorization

n = length(x);
X = x*x';
r = zeros(n,1);
for k = 1:n
    r(k) = 2*sum( diag( X, 1-k ) );
end
r(1) = r(1)/2;

L = 32*n;
S = real( fft(r,L) );
ar = log(S)/2;
X = fft(ar,L); 
X(1) = 0; X(2:L/2) = -1i*X(2:L/2); 
X(L/2+1) = 0; X(L/2+2:end) = 1i*X(L/2+2:end);
ai = ifft(X,L);
x_min = ifft( exp(ar-1i*ai), L );
x_min = x_min(1:n);