clear
clc

GS = 1; 

maxt = 1;

err = zeros(4,maxt);
ttt = zeros(2,maxt);
for trial = 1:maxt
    n = 2+randi(2^6);
    m = 2^( ceil(log2(n))+2 );
    fprintf( 'trial %d, n = %d, m = %d\n', trial, n, m )
    
    s1 = randn(n-1,1) + 1i*randn(n-1,1); s1 = s1/sqrt(2);
    b = abs( fft(s1,m) ).^2 ;
    
    %% direct measurement
    % Xinit = randn(n-1) + 1i*randn(n-1);
    % [ X, x_sdp, lambda, t1, t2 ] = solver_PR_1Dfft_REDUX( b, Xinit, opts );
    % x1 = x_sdp*(x_sdp'*s1)/abs(s1'*x_sdp);
    % err(1,trial) = norm( x1 - s1 )^2;
    % fprintf( '\t||x_t-x||^2= %f\n', err(1,trial) )
    
    x_min = pr1d_admm( b, n-1 );
    x1 = x_min*(x_min'*s1)/abs(s1'*x_min);
    err(1,trial) = norm( x1 - s1 )^2;
    fprintf( '\t||x_t-x||^2= %f\n', err(1,trial) )
    
    z0 = randn(n-1,1);
    for tt = 1:1000                     % Power iterations
        z0 = m*ifft(b.* fft(z0,m)); 
        z0 = z0(1:n-1)/norm(z0(1:n-1));
    end
    z0 = z0 * sqrt( sum(b)/m );
    x_fnp = FienupFFT( b, z0, GS );
    x2 = x_fnp*(x_fnp'*s1)/abs(s1'*x_fnp);
    err(2,trial) = norm( x2 - s1 )^2;
    fprintf( '\t||x_t-x||^2= %f\n', err(2,trial) )
    
    %% new measurement system
    s = [ norm(s1,1); s1 ];
    b = abs( fft(s,m) ).^2 ;
    
    % Fienup
    tic
    z0 = randn(n,1);
    for tt = 1:1000                     % Power iterations
        z0 = m*ifft(b.* fft(z0,m)); 
        z0 = z0(1:n)/norm(z0(1:n));
    end
    z0 = z0 * sqrt( sum(b)/m );
    x_fnp = FienupFFT( b, z0, GS );
    x = MPE(x_fnp);
    x = x*(x'*s)/abs(s'*x);
    x3 = x(2:end);
    err(3,trial) = norm(x3-s1)^2;
    fprintf( '\t||x_t-x||^2= %f\n', err(3,trial) )
    ttt(1,trial) = toc;
    
    % CoRK
    tic
    x_min = pr1d_admm( b, n );
    x = x_min*(x_min'*s)/abs(s'*x_min);
    x4 = x(2:end);
    err(4,trial) = norm( x4 - s1 )^2;
    fprintf( '\t||x_t-x||^2= %f\n', err(4,trial) )
    ttt(2,trial) = toc;
    
end
figure
semilogy( err(2,:), '-o' )
hold on
semilogy( err(1,:), '-d' )
semilogy( err(3,:), '-x' )
semilogy( err(4,:), '-s' )
hold off
legend( 'Direct: Fienup',...
    'Direct: CoRK',...
    'Minimum Phase: Fienup-SF',...
    'Minimum Phase: CoRK')
grid
axis( [ 0, 101, 1e-26, 1e5 ] )
xlabel('MC trials')
ylabel('estimation error')

figure
semilogy( ttt(1,:), '-x' )
hold on
semilogy( ttt(2,:), '-s' )
hold off
legend( 'Fienup-SF',...
    'CoRK',...
    'Location', 'Best' )
grid
axis( [ 0, 101, 1e-3, 1e2 ] )
xlabel('MC trials')
ylabel('time/seconds')