function op = linop_PR_1Dfft_REDUX( sz, m, n, lambda )

    op = @(X,mode) linop_PR_1Dfft_mat( sz, m, n, lambda, X, mode );
    
end

function out = linop_PR_1Dfft_mat( sz, m, n, lambda, X, mode )

    switch mode,
        case 0, out = sz ;
        case 1
            out = diag( fft( fft(X,m)', m ) );
            out = [ out; -lambda*real(X(1,1)) ];
        case 2
            Xt = ifft(X(1:m))*m;
            out = toeplitz( Xt(1:n), [ Xt(1);Xt(m:-1:m-n+2) ] ) ;
            out(1,1) = out(1,1) - lambda*real(X(end));
    end

end