%This function implements the linear operator ($\mathcal{A}$) in the
%Gaussian model of the 
%paper "Phase Retrieval from Coded Diffraction Patterns" by E. J. Candes, X. Li, and M. Soltanolkotabi

function op = linop_SF( sz, n )

    op = @(X,mode)linop_SF_mat( sz, n, X, mode );
    
end

function out = linop_SF_mat( sz, n, X, mode )

    switch mode,
        case 0, out = sz ;
        case 1
            out = real( X(1,1) );
        case 2
            out = zeros(n,n);
            out(1,1) = real(X);
    end

end