function [ x_min ] = pr1d_admm( b, n )
% sovles the phase retrieval problem with 1-D over-sampled Fourier
% measurements:
%       minimize    norm( b - abs(fft(x,m)).^2 )
% by first solve it in terms of auto-correlation of x, r
%       minimize    norm( b - real( fft(r,m) ) )
% subject to an approximate parameterization of r
%                   real( fft(r,L) ) >= 0
% where this L is large enough (here L=32*n)
% using ADMM.
% Then perform spectral factorization to obtain x_min, 
% which is minimum phase.

maxitr = 1e4;
tol = 1e-4;

m = length(b);
L = 2^ceil(log2(32*n));
rho = m/L;
% rho = 1;
r = zeros(n,1); r(1) = 2;
s = rand(L,1);
u = zeros(L,1);

Fb = ifft(b); Fb = m*Fb(1:n);
err1 = []; err2 = []; Fv = []; fv = randn(L,1);
fprintf('Iteration:     ');
for itr = 1:maxitr
    sp = s;
    
    fprintf('\b\b\b\b\b%5i',itr);
        t2 = ifft(s-u);
    r = 2*( Fb + rho*L*t2(1:n) ) / ( m + rho*L );
        r(1) = r(1)/2;
    Fr = real( fft(r,L) );
    s = max( 0, Fr + u );
    u = u + Fr - s;
    
    err1 = [ err1, norm(Fr-s)/norm(s) ];
    temp1 = real(2*ifft(sp-s));   temp1(1) = temp1(1)/2;
    temp2 = real(2*ifft(u));      temp2(1) = temp2(1)/2;
    err2 = [ err2, norm(temp1(1:n))/(tol+norm(temp2(1:n))) ];
    
    fv0 = fv;
    v = -s + u;
    d = ( u~=0 );
    F = sign(-Fr + d.*v) ; fv = F.*v;
    Fv = [Fv,norm(fv0-fv)];
    if err1(end) < tol && err2(end) < tol
        break
    end
end
fprintf('\n')
% figure
% semilogy(Fv, 'b')
% hold on
% plot(err2, 'r')
% semilogy( err1-err2 )
% hold on
% hold off
% err1(end)

% r2 = r/2; r2(1) = r(1);
% x_min = sp_kolmogorov(r2);
% L = 32*n;
S = real( fft(r,L) );
ar = log(S)/2;
X = fft(ar,L); 
X(1) = 0; X(2:L/2) = -1i*X(2:L/2); 
X(L/2+1) = 0; X(L/2+2:end) = 1i*X(L/2+2:end);
ai = ifft(X,L);
x_min = ifft( exp(ar-1i*ai), L );
x_min = x_min(1:n);