clear
clc

n = 128;

opts        = []    ;
opts.tol    = 1e-10 ;
opts.maxIts = 1e5   ;
opts.PrintEvery = 100   ;
opts.rank1 = 1; 

maxt = 100;
sdr = zeros(maxt,1);
fit = zeros(maxt,4); % col: [ spectral factorization, CoRK, Fienup ]
ttt = zeros(maxt,4);
for trial = 1:maxt
    m = 2*n + randi(6*n);
    b = rand(m,1);
    fprintf( 'trial %d, m = %d\n', trial, m )

        % PhaseLift
        Xinit = randn(n) + 1i*randn(n);
        [ X, x_sdp, lambda, t1, t2 ] = solver_PR_1Dfft_REDUX( b, Xinit, opts );
        [ x_pc, ~ ] = eigs( X, 1 );
        Fx_pc = abs( fft( x_pc, m ) ).^2;
        q = b'*Fx_pc/norm(Fx_pc)^2;
        x_pc = sqrt(q)*x_pc;
        
        ttt(trial,1) = t1;
        ttt(trial,2) = t2;
        sdr(trial,1) = norm( b - diag( fft( fft(X,m)', m ) ) )^2;
        fit(trial,1) = norm( b - abs( fft(x_pc, m) ).^2 )^2;
        fit(trial,2) = norm( b - abs( fft(x_sdp,m) ).^2 )^2;
        
        % CoRK
        tic
        x_min = pr1d_admm( b, n );
        ttt(trial,4) = toc;
        fit(trial,4) = norm( b - abs( fft(x_min,m) ).^2 )^2;
        
        % Fienup
        GS = 1;
        tic
        x_fnp = FienupFFT( b, randn(n,1), GS );
        ttt(trial,3) = toc;
        fit(trial,3) = norm( b - abs( fft(x_fnp,m) ).^2 )^2;
        

        % results: optimization
        fprintf( '\n---------------Optimization---------------------\n' )
        fprintf( 'SDR lower bound:\t\t\t\t %f \n', sdr(trial,1) );
        fprintf( '-solution extracted from spectral factorization: \n' )
        fprintf( '\tnorm( b - abs(Ax).^2 )^2 =\t %f\n', fit(trial,1) )
        fprintf( '-solution from AK: \n' )
        fprintf( '\tnorm( b - abs(Ax).^2 )^2 =\t %f\n', fit(trial,2) )
        fprintf( '-solution refined by Fienup: \n' )
        fprintf( '\tnorm( b - abs(Ax).^2 )^2 =\t %f\n', fit(trial,3) )    
    

end

c = max( eps, fit - repmat(sdr, 1, 4));
figure
semilogy( c(:,1), '-d' )
hold on
semilogy( c(:,2), '-o' )
semilogy( c(:,3), '-x' )
semilogy( c(:,4), '-s' )
hold off
legend( 'PhaseLift-PC',...
    'PhaseLift-SF', ...
    'Fienup', ...
    'CoRK', ...
    'Location', 'Best' )
grid
xlabel('MC trials')
ylabel('f-f_*')
axis( [ 0,101,1e-16,1e3 ] )

figure
semilogy( ttt(:,1), '-d' )
hold on
semilogy( ttt(:,2), '-o' )
semilogy( ttt(:,3), '-x' )
semilogy( ttt(:,4), '-s' )
hold off
legend( 'PhaseLift',...
    'PhaseLift-SF', ...
    'Fienup', ...
    'CoRK', ...
    'Location', 'Best' )
grid
xlabel('MC trials')
ylabel('time/seconds')
axis( [ 0,101,1e-3,1e2 ] )