% This code implements 

% min ||y-fft(X)||^2-lambda*X(1,1)
% subject to
% X is positive semi-definite

function [ X1, x, lambda, t1, t2 ] = solver_PR_1Dfft_REDUX( b, X0, opts )
tic

rank1 = opts.rank1;
opts.rank1 = [];
if ~isfield( opts, 'restart' ), 
    opts.restart = 100; 
end

n = size(X0,1);
m = length(b);

FF = linop_PR_1Dfft( { [n,n], [m,1] }, m, n ) ; 

% fitting error
[X1,odata,opts] = tfocs( smooth_quad, {FF,-b}, proj_psd, X0, opts );
while strcmp( odata.status, 'Unexpectedly small stepsize' )
    X0 = randn(n) + 1i*randn(n);
    [X1,odata,opts] = tfocs( smooth_quad, {FF,-b}, proj_psd, X0, opts );
end

SDR = norm( b - diag( fft( fft(X1,m)', m ) ) )^2;
t1 = toc

if rank1 == 1
    % find good lambda
    lower = 0;
    upper = SDR;
    lambda = SDR;
    X = X0;
    eigen = eig(X); eigen = sort(real(eigen));
    E = eye(m+1);
    e = E(:,end); E(end,end)=0;
    while eigen(end-1)/eigen(end) > 1e-4
%         lower = lambda;
        lambda = upper;
        upper = 10*lambda;
        FF = linop_PR_1Dfft_REDUX( { [n,n], [m+1,1] }, m, n, lambda ) ;
        [X,odata,opts] = tfocs( smooth_quad(E,e), {FF,-[b;0]}, proj_psd, X, opts );

        eigen = eig(X); eigen = sort(real(eigen));
    end
%     pause
    SDR1 = norm( b - diag( fft( fft(X,m)', m ) ) )^2;
    while ~( eigen(end-1)/eigen(end) < 1e-4 && SDR1/SDR < 1+1e-4 )
        lambda = (lower+upper)/2;
        FF = linop_PR_1Dfft_REDUX( { [n,n], [m+1,1] }, m, n, lambda ) ;
        [X,odata,opts] = tfocs( smooth_quad(E,e), {FF,-[b;0]}, proj_psd, X, opts );

        SDR1 = norm( b - diag( fft( fft(X,m)', m ) ) )^2;

        if SDR1/SDR < 1+1e-8
            lower = lambda;
        else
            upper = lambda;
        end

        eigen = eig(X); eigen = sort(real(eigen));

        if upper - lower < .01
            break
        end
    end

    x = full( X(:,1)/sqrt(X(1,1)) );

    norm( b - diag( fft( fft(X1,m)', m ) ) )^2
    norm( b - abs( fft(x,m) ).^2 ).^2
end
t2 = toc

end

