clear
clc

maxt = 100;
n = 2^10;
s1 = randn(n-1,1) + 1i*randn(n-1,1); s1 = s1/sqrt(2);
s  = [ 3*n; s1 ];

m = 8*n;
crb1 = zeros(4,1);
err1 = zeros(4,maxt);
erf1 = zeros(4,maxt);
for k = 1:4
    SNR = 20+10*k;
    sigma = sqrt( sum( abs( fft(s,m) ).^4 )/(m*10^(SNR/10)) );
    
    % CRB direct method
    F = dftmtx(m); F = F(:,1:n);
    % G = F'*diag(fft(s,m));
    % fim1 = G*G';
    % fim1 = [ real(fim1), imag(fim1); -imag(fim1), real(fim1) ];
    G1 = [ real(F'*diag(fft(s,m))); imag(F'*diag(fft(s,m))) ];
    finv = pinv(G1*G1'*4/sigma^2);
    
    % efficient?
    % t = m*ifft(b);
    % fim2 = toeplitz( t(1:n), [t(1);t(m:-1:m-n+2)] )';
    % fim4 = [ real(fim2), -imag(fim2); imag(fim2), real(fim2) ];
    
    si = [ 2:n, n+2:2*n ];
    crb1(k) = trace(finv(si,si))/norm(s1)^2;
    
    for trial = 1:maxt
        b = abs( fft(s,m) ).^2 + sigma*randn(m,1);
        x_min = pr1d_admm( b, n );
        x = x_min*exp( -1i*angle(x_min(1)) );
        x = x(2:end);

        err1(k,trial) = norm(x-s1)^2/norm(s1)^2;
        
        x_fnp = FienupFFT( b, x_min, 1 );
        x = MPE(x_fnp);
        x = x*exp( -1i*angle(x(1)) );
        x = x(2:end);
        erf1(k,trial) = norm(x-s1)^2/norm(s1)^2;
    end
end

SNR = 40;
crb2 = zeros(4,1);
err2 = zeros(4,maxt);
erf2 = zeros(4,maxt);
for k = 1:4
    m = 2^k*n;
    sigma = sqrt( sum( abs( fft(s,m) ).^4 )/(m*10^(SNR/10)) );
    
    % CRB direct method
    F = dftmtx(m); F = F(:,1:n);
    % G = F'*diag(fft(s,m));
    % fim1 = G*G';
    % fim1 = [ real(fim1), imag(fim1); -imag(fim1), real(fim1) ];
    G1 = [ real(F'*diag(fft(s,m))); imag(F'*diag(fft(s,m))) ];
    finv = pinv(G1*G1'*4/sigma^2);
    
    % efficient?
    % t = m*ifft(b);
    % fim2 = toeplitz( t(1:n), [t(1);t(m:-1:m-n+2)] )';
    % fim4 = [ real(fim2), -imag(fim2); imag(fim2), real(fim2) ];
    
    si = [ 2:n, n+2:2*n ];
    crb2(k) = trace(finv(si,si))/norm(s1)^2;
    
    for trial = 1:maxt
        b = abs( fft(s,m) ).^2 + sigma*randn(m,1);
        x_min = pr1d_admm( b, n );
        x = x_min*exp( -1i*angle(x_min(1)) );
        x = x(2:end);

        err2(k,trial) = norm(x-s1)^2/norm(s1)^2;
        
        x_fnp = FienupFFT( b, x_min, 1 );
        x = MPE(x_fnp);
        x = x*exp( -1i*angle(x(1)) );
        x = x(2:end);
        erf2(k,trial) = norm(x-s1)^2/norm(s1)^2;
    end
end

k = 1:4;
figure
subplot(1,2,2)
SNR = 20+10*k;
plot(SNR,log10(crb1),'--','LineWidth',2)
ytick = get(gca, 'YTick');
str = cellstr( num2str(ytick(:),'10^{%1d}') );
format_ticks(gca,{'30','40','50','60'},str(1:2:end),[30,40,50,60],ytick(1:2:end));
hold on
plot(SNR,log10(mean(err1,2)),'-o')
plot(SNR,log10(mean(erf1,2)),'-x')
hold off
% axis([30,60,1e-3,1e1])
grid
xlabel({'','SNR'})
title 'M=8N'
subplot(1,2,1)
m = 2.^k;
plot(k,log10(crb2),'--','LineWidth',2)
ytick = get(gca, 'YTick');
str = cellstr( num2str(ytick(:),'10^{%1.1f}') );
format_ticks(gca,{'2N','4N','8N','16N'},str(1:3:end),[1,2,3,4],ytick(1:3:end));
hold on
plot(k,log10(mean(err2,2)),'-o')
plot(k,log10(mean(erf2,2)),'-x')
hold off
grid
xlabel({'','number of measurements'})
ylabel({'normalized error','',''})
title('SNR = 40dB')
% axis([1,4,.05,.5])
legend('CRB','CoRK','Fienup-SF')

% save