%This function implements the linear operator ($\mathcal{A}$) in the
%Gaussian model of the 
%paper "Phase Retrieval from Coded Diffraction Patterns" by E. J. Candes, X. Li, and M. Soltanolkotabi

function op = linop_PR_1Dfft( sz, m, n )

    op = @(X,mode) linop_PR_1Dfft_mat( sz, m, n, X, mode );
    
end

function out = linop_PR_1Dfft_mat( sz, m, n, X, mode )

    switch mode,
        case 0, out = sz ;
        case 1
            out = diag( fft( fft(X,m)', m ) );
        case 2
            Xt = ifft(X)*m;
            out = toeplitz( Xt(1:n), [ Xt(1);Xt(m:-1:m-n+2) ] ) ;
            
    end

end