clear
clc

n = 32;
m = 4*n;

s = randn(n-1,1) + 1i*randn(n-1,1); s = s/sqrt(2);
% x = [ norm(x,1); x ];
s = [ 3*n; s ];
% s = [ randn+1i*randn; s ];
sigma = 10;
b = abs( fft(s,m) ).^2 + sigma*randn(m,1);
% b = rand(m,1);

%% SDR + spectral factorization
opts        = []    ;
opts.tol    = 1e-10 ;
opts.maxIts = 1e5   ;
opts.PrintEvery = 100   ;
opts.rank1 = 1; 
% opts.alg = 'TS';

Xinit = randn(n) + 1i*randn(n);
% [ X, x_sdp, lambda, t1, t2 ] = solver_PR_1Dfft( b, Xinit, opts );
[ X, x_sdp, lambda, t1, t2 ] = solver_PR_1Dfft_REDUX( b, Xinit, opts );
% eig(X)

%% admm
tic
x_min = pr1d_admm( b, n );
toc

%% Fienup
GS = 1;
tic
x_fnp = FienupFFT( b, randn(n,1), GS );
toc

%% results
% optimization
fprintf( '\n\n---------------Optimization---------------------\n' )
SDR = norm( b - diag( fft( fft(X,m)', m ) ) )^2;
fprintf( 'SDR lower bound:\t\t %f \n', SDR );
SDP_sf = norm( b - abs( fft(x_sdp,m) ).^2 ).^2;
fprintf( 'SDP sf:\t\t\t\t\t %f \n', SDP_sf );
SDP_sf = norm( b - abs( fft(x_min,m) ).^2 ).^2;
fprintf( 'ADMM:\t\t\t\t\t %f \n', SDP_sf );
SDP_sf = norm( b - abs( fft(x_fnp,m) ).^2 ).^2;
fprintf( 'Fienup:\t\t\t\t\t %f \n', SDP_sf );

fprintf( '\n\n---------------Other criterion------------------\n' )
SDP_sf = norm( sqrt(b) - abs( fft(x_min,m) ) ).^2;
fprintf( 'ADMM:\t\t\t\t\t %f \n', SDP_sf );
SDP_sf = norm( sqrt(b) - abs( fft(x_fnp,m) ) ).^2;
fprintf( 'Fienup:\t\t\t\t\t %f \n', SDP_sf );