function [x,errVec]=GN(S,c,n,x0,iterations,w)
    x=zeros(n,1);
    x(S)=x0;
    s=0.5;
    W=dftmtx(sqrt(n));
    ind=0;
    %%% Building MM matrix on the fly
    for indS=S
        alpha=ceil(indS/sqrt(n));
        beta=mod(indS,sqrt(n));
        if (beta==0)
            beta=sqrt(n);
        end
        ind=ind+1;
        MM(:,ind)=kron(W(:,alpha),W(:,beta));
    end
    %%% GN
    for i=1:iterations
        s=min([2*s,1]);
        z=fft2(reshape(x,sqrt(n),sqrt(n)));
        z=z(:);
        XM=w.*(z');
        B=bsxfun(@times,real(z).*sqrt(w'),real(MM))+bsxfun(@times,imag(z).*sqrt(w'),imag(MM));
        b=sqrt(w').*(c+abs(z).^2);
        xold=x;
        fold=WG_cost(c,xold,w);
        x=zeros(n,1);
        x(S)=2*B\b;
        xnew=x;
        while((WG_cost(c,xold+s*(xnew-xold),w)>fold))% && (s>1e-5))
            s=0.5*s;
        end
        x=xold+s*(xnew-xold);
        errVec(i)=fold;
        if (norm(x-xold)<1e-4)
            return
        end
    end
end