function T = fdrThres(x, q, sdev)
 % T = fdrThres(x, q, sdev)
 %
 % fdrThres applies the FDR thresholding procedure, assuming normal noise.
 % 
 % Input:
 % x: input signal
 % q: FDR q parameter.
 % sdev: standard deviation of the noise.
 % 
 % Output:
 % T: The resulting threshold.
 %
 %
 %    Copyright (C) 2008  Erez Ben-Yaacov
 %
 %    This program is free software: you can redistribute it and/or modify
 %    it under the terms of the GNU General Public License as published by
 %    the Free Software Foundation, either version 3 of the License, or
 %    (at your option) any later version.
 %
 %    This program is distributed in the hope that it will be useful,
 %    but WITHOUT ANY WARRANTY; without even the implied warranty of
 %    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %    GNU General Public License for more details.
 %    <http://www.gnu.org/licenses/>

if numel(x) < 2
    T = 0;
    return;
end
 
if size(x,2) > 1
    x = x';
end

M = numel(x);
m = (1:M)'/M;
sortedX = sort(abs(x));
sortedX = sortedX(end:-1:1);
p = 2*(1 - normcdf(sortedX, 0, sdev));
k = find((p <= m*q), 1, 'last');
if (numel(k) == 0)
    T = sortedX(1) + 1e-16;
else
    T = sortedX(k);
end