/* 
 *    Copyright (C) 2008  Erez Ben-Yaacov
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *    <http://www.gnu.org/licenses/>
 *
 */

#include "mex.h"
#include "HaarSeg.c"

#define NARGIN 2
#define NARGOUT 1

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
    double * signal;
    int * peakLoc;
    int * newPeakLoc;
    int signalSize;
    unsigned int mrows,ncols, dims[2];

    /* Check for proper number of arguments. */
    if (nrhs != NARGIN) {
        mexErrMsgTxt("2 inputs required.");
    } 
    if(nlhs > NARGOUT) {
        mexErrMsgTxt("Too many output arguments");
    }

    mrows = mxGetM(prhs[0]);
    ncols = mxGetN(prhs[0]);
    signalSize = (int) (ncols * mrows);

    signal = mxGetPr(prhs[0]);
    peakLoc = mxGetPr(prhs[1]);
    
    dims[0] = signalSize;
    dims[1] = 1;
    plhs[0] = mxCreateNumericArray(2,dims, mxINT32_CLASS, mxREAL);
    newPeakLoc = mxGetData(plhs[0]);

    AdjustBreaks(signal,signalSize,peakLoc,newPeakLoc);
}


