/* 
 *    Copyright (C) 2008  Erez Ben-Yaacov
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *    <http://www.gnu.org/licenses/>
 *
 */

#include "mex.h"
#include "HaarSeg.c"

#define NARGIN 3
#define NARGOUT 2

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
    double * signal;
    double * convResult;
    double * weight;
    int * peakLoc;
    int signalSize;
    int stepHalfSize;
    unsigned int mrows,ncols, dims[2];

    /* Check for proper number of arguments. */
    if (nrhs == 2) {
        weight = NULL;
    }
    else if (nrhs == 3) {
        weight = mxGetPr(prhs[2]);
    }
    else {
        mexErrMsgTxt("2 or 3 inputs required.");
    } 
    if(nlhs > NARGOUT) {
        mexErrMsgTxt("Too many output arguments");
    }

    mrows = mxGetM(prhs[0]);
    ncols = mxGetN(prhs[0]);
    signalSize = (int) (ncols * mrows);

    signal = mxGetPr(prhs[0]);
    stepHalfSize = (int) *mxGetPr(prhs[1]);
    
    plhs[0] = mxCreateDoubleMatrix(signalSize,1, mxREAL);
    convResult = mxGetPr(plhs[0]);
    dims[0] = signalSize;
    dims[1] = 1;
    plhs[1] = mxCreateNumericArray(2,dims, mxINT32_CLASS, mxREAL);
    peakLoc = mxGetData(plhs[1]);

    HaarConv(signal, weight, signalSize, stepHalfSize, convResult);
    FindLocalPeaks(convResult, signalSize, peakLoc);

}


