/* 
 *    Copyright (C) 2008  Erez Ben-Yaacov
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *    <http://www.gnu.org/licenses/>
 *
 */

#include "mex.h"
#include "HaarSeg.c"

#define NARGIN 5
#define NARGOUT 1

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
    double * addon;
    int * addonPeaks;
    int * basePeaks;
    int * uniPeaks;
    double threshold;
    int windowSize;
    
    unsigned int dims[2];

    /* Check for proper number of arguments. */
    if (nrhs != NARGIN) {
        mexErrMsgTxt("5 inputs required.");
    } 
    if(nlhs > NARGOUT) {
        mexErrMsgTxt("Too many output arguments");
    }

    dims[0] = mxGetM(prhs[0]);
    dims[1] = mxGetN(prhs[0]);

    addon = mxGetPr(prhs[0]);
    addonPeaks = (int *) mxGetData(prhs[1]);
    basePeaks = (int *) mxGetData(prhs[2]);
    threshold = *mxGetPr(prhs[3]);
    windowSize = *(int *)mxGetData(prhs[4]);

    plhs[0] = mxCreateNumericArray(2,dims, mxINT32_CLASS, mxREAL);
    uniPeaks = (int *) mxGetData(plhs[0]);

    HardThreshold(addon, threshold, addonPeaks);
    UnifyLevels(basePeaks, addonPeaks, windowSize, dims[0]*dims[1], uniPeaks);
    
}


