function same = myttest2(y1,y2,sig,ttable)
 % same = myttest2(y1,y2,sig,ttable)
 %
 % double sided t-test 
 % 
 % Input:
 % y1: samples which belong to the first segment
 % y2: samples which belong to the second segment
 % sig: the sigma of the zero-mean gaussian noise.
 % ttable: a pre-calculated table with relevant thresholds.
 % 
 % Output:
 % same: binary flag. If it is non-zero, it means the null-hypothesis is
 % true, and the two segments share the same mean, according to the t-test
 % (using the pre-defined p-value in ttable).
 %
 %
 %    Copyright (C) 2008  Erez Ben-Yaacov
 %
 %    This program is free software: you can redistribute it and/or modify
 %    it under the terms of the GNU General Public License as published by
 %    the Free Software Foundation, either version 3 of the License, or
 %    (at your option) any later version.
 %
 %    This program is distributed in the hope that it will be useful,
 %    but WITHOUT ANY WARRANTY; without even the implied warranty of
 %    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %    GNU General Public License for more details.
 %    <http://www.gnu.org/licenses/>

n1 = numel(y1);
n2 = numel(y2);
t = (mean(y1) - mean(y2))./(sig.*sqrt(1/n1 + 1/n2));
if (-abs(t) < ttable(n1+n2-2))
    same = 0;
else
    same = 1;
end