function segs = segmentByPeaks(data,peaks,segType,weights)
 % segs = segmentByPeaks(data,peaks,segType,weights)
 %
 % segmentByPeaks creates a signal from a list of breakpoints.
 % 
 % Input:
 % data:  the raw data, before segmentation
 % peaks: list of indexes of the breakpoints detected in the data.
 % segType: use the string 'mean' for the mean estimator, and 'median'
 %        for the median estimator. If using weights, only the 'mean'
 %        estimator can be used.   
 % weights: if weights exists, they are to be entered.
 % 
 % Output:
 % segs: the segmentation result. This vector is of the same size of data.
 %
 %
 %    Copyright (C) 2008  Erez Ben-Yaacov
 %
 %    This program is free software: you can redistribute it and/or modify
 %    it under the terms of the GNU General Public License as published by
 %    the Free Software Foundation, either version 3 of the License, or
 %    (at your option) any later version.
 %
 %    This program is distributed in the hope that it will be useful,
 %    but WITHOUT ANY WARRANTY; without even the implied warranty of
 %    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %    GNU General Public License for more details.
 %    <http://www.gnu.org/licenses/>

if nargin < 4
    weights = [];
end

if strmatch(segType,'mean')
    segType = 0;
elseif strmatch(segType,'median')
    segType = 1;
end

% peaks = find(peaks);
st = [1;peaks];
ed = [peaks-1;numel(data)];

segs = data;
for k = 1:numel(st)
    if segType == 0
        if (numel(weights) > 0)
            segs(st(k):ed(k)) = sum(weights(st(k):ed(k)) .* data(st(k):ed(k))) / sum(weights(st(k):ed(k)));
        else
            segs(st(k):ed(k)) = mean(data(st(k):ed(k)));
        end
    elseif segType == 1;
        segs(st(k):ed(k)) = median(data(st(k):ed(k)));
    end
end