function y = stepConv(x,L)
 % y = stepConv(x,L)
 %
 % stepConv convolves the signal x with a step of width L.
 % Circular padding is used.
 % 
 % Input:
 % x: input signal
 % L: step widthThe segmentation result of your algorithm. If several arrays exists, 
 %      a matrix can be used, where each column is a different array.
 % 
 % Output:
 % y: Convolution result.
 %
 %
 %    Copyright (C) 2008  Erez Ben-Yaacov
 %
 %    This program is free software: you can redistribute it and/or modify
 %    it under the terms of the GNU General Public License as published by
 %    the Free Software Foundation, either version 3 of the License, or
 %    (at your option) any later version.
 %
 %    This program is distributed in the hope that it will be useful,
 %    but WITHOUT ANY WARRANTY; without even the implied warranty of
 %    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %    GNU General Public License for more details.
 %    <http://www.gnu.org/licenses/>

x = x(:);
%padding
x = [x(L/2:-1:1);x;x(end:-1:end-L/2+2)];
%conv
step = ones(L,1)/L;
y = conv2(double(x),step,'valid');