function y = thresBySig(raw,seg,K,chrompos)
 % y = thresBySig(raw,seg,K,chrompos)
 %
 % thresBySig sets to zero all values in seg which their absolute value 
 % is below K*sdev. sdev is estimated as the variance of the difference 
 % (raw - seg).
 %
 % Input:
 % raw: The raw measurments. If several arrays exists, a matrix can be used,
 %      where each column is a different array.
 % seg: The segmentation result of your algorithm. If several arrays exists, 
 %      a matrix can be used, where each column is a different array.
 %      The size of seg matix should match exactly the size of raw matrix. 
 % K:   A parameter which indicated how many std should be zeroed out. 
 %      Setting K to a high value will result in the detection of only the most
 %      abberant segments. 
 % chrompos: A matrix of two columns. The first column is the start index 
 %      of each chromosome. The second column is the end index of each chromosome.
 % 
 % Output:
 % y:   Values of seg, after the threshold. 
 %
 %
 %    Copyright (C) 2008  Erez Ben-Yaacov
 %
 %    This program is free software: you can redistribute it and/or modify
 %    it under the terms of the GNU General Public License as published by
 %    the Free Software Foundation, either version 3 of the License, or
 %    (at your option) any later version.
 %
 %    This program is distributed in the hope that it will be useful,
 %    but WITHOUT ANY WARRANTY; without even the implied warranty of
 %    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %    GNU General Public License for more details.
 %    <http://www.gnu.org/licenses/>

y = seg;
for i = 1:size(chrompos,1)
    st = chrompos(i,1);
    ed = chrompos(i,2);
    stdEst = median(abs(raw(st:ed,:) - seg(st:ed,:))) ./ 0.6745;
    T = ones(ed-st+1,1)*K*stdEst;
    yy = seg(st:ed,:);
    yy(abs(seg(st:ed,:)) < T) = 0;
    y(st:ed,:) = yy;
end