function nb = ttestUnify(b,y,sig,ttable)
 % nb = ttestUnify(b,y,sig,ttable)
 %
 % ttestUnify tries to unify nearby segments if they have a similar 
 % value, by using a t-test.
 % 
 % Input:
 % b: input breakpoints.
 % y: input signal.
 % sig: the sigma of the zero-mean gaussian noise.
 % ttable: a pre-calculated table with relevant thresholds.
 % 
 % Output:
 % nb: updated breakpoints.
 %
 %
 %    Copyright (C) 2008  Erez Ben-Yaacov
 %
 %    This program is free software: you can redistribute it and/or modify
 %    it under the terms of the GNU General Public License as published by
 %    the Free Software Foundation, either version 3 of the License, or
 %    (at your option) any later version.
 %
 %    This program is distributed in the hope that it will be useful,
 %    but WITHOUT ANY WARRANTY; without even the implied warranty of
 %    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %    GNU General Public License for more details.
 %    <http://www.gnu.org/licenses/>

st = [1;b];
ed = [b-1;numel(y)];

st1 = st(1);
nb = zeros(size(b));
nk = 1;

for k = 1:numel(b)
    y1 = y(st1:ed(k));
    y2 = y(st(k+1):ed(k+1));
    if (max(numel(y1),numel(y2))) > 2
        uni = myttest2(y1,y2,sig,ttable);
    else
        uni = 0;
    end
    if (uni)
       % do nothing 
    else
       nb(nk) = b(k);
       nk = nk + 1;
       st1 = st(k+1);
    end
end
nb = nb(1:nk-1);