function h=ButterCorrect(w0,order,l,n,Tp)

% This function create the butterworth digital correction filters
% Written by Kfir Gedalyahu and Rami Cohen

% w0 - analog filter cuttoff freq
% order - analog filter order
% l - band index
% n - discrete time vec
% Tp - period of pulses


[b,a] = butter(order,w0,'s');
w1=2*pi*(l-1);
w2=2*pi*(l);

H=zeros(order+1,length(n));
H(1,:)=1./(1i*n).*(exp(1i*w2*n)-exp(1i*w1*n));
H(1,n==0)=w2-w1;

for m=1:order
    H(m+1,:)=(1i*w2)^m./(1i*n).*exp(1i*w2*n)-(1i*w1)^m./(1i*n).*exp(1i*w1*n)-m./n.*H(m,:);
    H(m+1,n==0)=1i^m/(m+1)*(w2^(m+1)-w1^(m+1));
end

h=fliplr(a)*H/b(order+1);

