function h=CreateSeq(K,N,dist,fm,Energy)

% This function creates the gain coefficients according to desired model and energy
% Written by Kfir Gedalyahu and Rami Cohen

% K - number of paths
% N- sequence length
% dist - 1 for WGN, 2 for Jakes, 3 for Rounded
% fm - doppler rate
% Energy - desired average energy of the sequences


h=zeros(K,N);

switch (dist)
    case (1) % WGN
    h=randn(K,N)+1i*randn(K,N);
    case (2) % Jakes
        chan = rayleighchan(1,fm);
        chan.DopplerSpectrum=doppler.jakes;
              for i=1:K
                  x=ones(1,N);
                  h(i,:)=filter(chan,x);
              end              
    case (3) % Rounded
        chan = rayleighchan(1,fm);
        chan.DopplerSpectrum=doppler.rounded;
              for i=1:K
                  x=ones(1,N);
                  h(i,:)=filter(chan,x);
              end
    otherwise
        disp('Problem!');
        return;
end

%Normalizing Energy

for i=1:K
    E_calc=(1/N)*h(i,:)*h(i,:)';
    E_factor=E_calc/Energy(i);
    h(i,:)=h(i,:)/sqrt(E_factor);
end

end