function tk=TLS_ESPRIT(C,K,T)

%% This function implements the TLS-ESPRIT algorithm to recover the delays from noisy samples
%% Written by Kfir Gedalyahu and Rami Cohen

% C - samples;
% K - number of exponents
% T - sampling time

p=size(C,1);

% stage 1 - obtain estimate of Rzz
X=C(1:end-1,:);
Y=C(2:end,:);
Z=[X;Y];
Rzz=Z*Z';

% stage 2 - compute eigenvalues decompostion of Rzz
[E,D] = svd(Rzz);

% stage 4 - obtain signal subspace
Es=E(:,1:K);

% stage 5 
Exy=[Es(1:p-1,:) Es(p:end,:)];
conjExy=[Es(1:p-1,:)'; Es(p:end,:)'];
EE=conjExy*Exy;
[U,S,E]=svd(EE);
E12=E(1:K,K+1:end);
E22=E(K+1:end,K+1:end);

% stage 6
psi=-E12*inv(E22);
tk=sort(mod(-angle(eig(psi))/(2*pi/T),T));