% GUI for the demonstration of the algorithm
% Written by Kfir Gedalyahu and Rami Cohen

function varargout = LRTDE(varargin)
% LRTDE M-file for LRTDE.fig
%      LRTDE, by itself, creates a new LRTDE or raises the existing
%      singleton*.
%
%      H = LRTDE returns the handle to a new LRTDE or the handle to
%      the existing singleton*.
%
%      LRTDE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in LRTDE.M with the given input arguments.
%
%      LRTDE('Property','Value',...) creates a new LRTDE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before LRTDE_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to LRTDE_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help LRTDE
% Last Modified by GUIDE v2.5 17-Feb-2010 00:42:41

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @LRTDE_OpeningFcn, ...
                   'gui_OutputFcn',  @LRTDE_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before LRTDE is made visible.
function LRTDE_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to LRTDE (see VARARGIN)
global insert_ok;
global first_run;
global current_pos;
global k_list;
first_run=1;
k_list={'1' '2' '3' '4' '5' '6' '7' '8' '9' '10'};

% initializing the GUI with predefined values 
set(handles.order,'Enable','off'); % disable 'order' box
set(handles.order_text,'Enable','off'); % disable 'order_text' box
set(handles.N,'string',100);
set(handles.Gain_Seq,'value',2);
initial_values={'0.22' '0.5' '0.6' '0.95' '' '' '' '' '' '';'1' '0.5' '0.25' '0.125' '' '' '' '' '' ''}';
set(handles.User_Table,'data',initial_values);
set(handles.P,'string','6')
set(handles.fm,'string','0.05')
set(handles.SNR,'string','40')
current_pos=4;
insert_ok=zeros(1,2);
  
% Choose default command line output for LRTDE
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = LRTDE_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
simulate_Callback(handles.simulate,1,handles)

% --- Executes on button press in simulate.
function simulate_Callback(hObject, eventdata, handles)
% hObject    handle to simulate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global current_pos; % row position in the table
global k_list;
global h;
global Aout;
global Cn;

if (current_pos==0) % no data
    msgboxText{1} =  'Enter data';
    msgbox(msgboxText,'No data', 'warn');
    return;
end;

data_ok=check_data(handles);%checking the data

if (data_ok==0) 
    return; 
end

w_bar = waitbar(0,'Please wait...');
waitbar(0,w_bar,sprintf('Initializing...'))

K=current_pos;

set(handles.axes_k,'string',k_list(1:K));
set(handles.axes_k,'value',1)

% Reading data

p=str2double(get(handles.P,'string'));
User_Table=get(handles.User_Table,'data');
Tau=str2num(char(User_Table(:,1)));
[Tau_sorted,ind]=sort(Tau);
Energy=str2num(char(User_Table(:,2)));
N=str2double(get(handles.N,'string'));
SNR=str2double(get(handles.SNR,'string'));
dist=get(handles.Gain_Seq,'value');
fm=str2double(get(handles.fm,'string'));
order=get(handles.order,'value')+2;
f_type=get(handles.filter_type,'value');

h=zeros(K,N);
h_new=zeros(K,N);
A=zeros(K,N);
t_new=zeros(K,1);
h=CreateSeq(K,N,dist,fm,Energy(ind));

% filtering

switch (f_type)
    case (1)
        [Cn,C]=AnalogSampling_GUI(Tau_sorted,p,h,SNR,'LPF',1,w_bar);
        [Aout,tk]=ChanRecover_GUI(Cn(1:10:end,:),K,N,1000,'LPF',1,w_bar);
        
    case (2)
        [Cn,C]=AnalogSampling_GUI(Tau_sorted,p,h,SNR,'BLPF',order,w_bar);
        [Aout,tk]=ChanRecover_GUI(Cn(1:10:end,:),K,N,1000,'BLPF',order,w_bar);
end

% retrieving the non-sorted values

for i=1:K
    A(ind(i),:)=Aout(i,:);
    t_new(ind(i))=tk(i);
    h_new(ind(i),:)=h(i,:);
end

Aout=A;
tk=t_new;
h=h_new;

% plotting

set(handles.LLim,'String','0');
set(handles.RLim,'String',get(handles.N,'string'));
plot_analog(Cn,handles);
plot_de(Aout,h,tk,N,handles)
plot_seq(h,Aout,handles,N);
close(w_bar);

return


% --- Executes on selection change in filter_type.
function filter_type_Callback(hObject, eventdata, handles)
% hObject    handle to filter_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns filter_type contents as cell array
%        contents{get(hObject,'Value')} returns selected item from filter_type

% disabling 'order' parameter when using sinc

f_type=get(hObject,'value');
if f_type==2
    set(handles.order,'Enable','on');
    set(handles.order_text,'Enable','on');
else
    set(handles.order,'Enable','off');
    set(handles.order_text,'Enable','off');
end
    
   
% --- Executes during object creation, after setting all properties.
function filter_type_CreateFcn(hObject, eventdata, handles)
% hObject    handle to filter_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function SNR_Callback(hObject, eventdata, handles)
% hObject    handle to SNR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR as text
%        str2double(get(hObject,'String')) returns contents of SNR as a double

SNR=get(hObject,'string');
if isempty(SNR) return;end;
SNR=str2num(SNR);
    

if not(check_number(SNR))   
    set(handles.SNR,'string','');
    return;
end
    

% --- Executes during object creation, after setting all properties.
function SNR_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function P_Callback(hObject, eventdata, handles)
% hObject    handle to P (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of P as text
%        str2double(get(hObject,'String')) returns contents of P as a double
global current_pos;

P=get(hObject,'String');
if isempty(P) return; end;
P=str2num(P);

if not(check_number (P))
    set(handles.P,'string','');
    return;
end

if current_pos==0 
    return;
end

if (mod(P,2)~=0)
    msgboxText{1} =  'p must be an even number.'; 
    msgbox(msgboxText,'Input is not an even number', 'warn');
    set(handles.P,'string','');
    return;
end;

if (P<=0)
    msgboxText{1} =  'p must be positive.';
    msgbox(msgboxText,'Change p', 'warn');
    set(handles.P,'string',[]);
    return;
end;

if (P<current_pos)
    msgboxText{1} =  ['p must be greater than K when using sinc.'] ; 
    msgboxText{2} =  ['p must be greater than 2K when using Butteworth.'] ; 
    msgbox(msgboxText,'Change p', 'warn');
    set(handles.P,'string','');
    return;
end;





% --- Executes during object creation, after setting all properties.
function P_CreateFcn(hObject, eventdata, handles)
% hObject    handle to P (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on key press with focus on simulate and none of its controls.
function simulate_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to simulate (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function User_Table_CreateFcn(hObject, eventdata, handles)
% hObject    handle to User_Table (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes when entered data in editable cell(s) in User_Table.
function User_Table_CellEditCallback(hObject, eventdata, handles)
% hObject    handle to User_Table (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) edited
%	PreviousData: previous data for the cell(s) edited
%	EditData: string(s) entered by the user
%	NewData: EditData or its converted form set on the Data property. Empty if Data was not changed
%	Error: error string when failed to convert EditData to appropriate value for Data
%   handles    structure with handles and user data (see GUIDATA)
%   User_Table is not editable by user


% --- Executes on selection change in Gain_Seq.
function Gain_Seq_Callback(hObject, eventdata, handles)
% hObject    handle to Gain_Seq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Gain_Seq contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Gain_Seq
sn=get(hObject,'Value');

if (sn>1)
    set(handles.fm,'Enable','on');
    set(handles.fm_text,'Enable','on');
else
    set(handles.fm,'Enable','off');
    set(handles.fm_text,'Enable','off');
end;



% --- Executes during object creation, after setting all properties.
function Gain_Seq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gain_Seq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function N_Callback(hObject, eventdata, handles)
% hObject    handle to N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N as text
%        str2double(get(hObject,'String')) returns contents of N as a double

N=get(hObject,'String');
if isempty(N) return; end;
N=str2num(N);

if not(check_integer(N))
    set(handles.N,'string',[]);
    return;
end

if (N<=0)
    msgboxText{1} =  'Sequence length must be positive.';
    msgbox(msgboxText,'Invalid sequence length.', 'warn');
    set(handles.N,'string',[]);
end


% --- Executes during object creation, after setting all properties.
function N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over simulate.
function simulate_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to simulate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


function fm_Callback(hObject, eventdata, handles)
% hObject    handle to fm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of fm as text
%        str2double(get(hObject,'String')) returns contents of fm as a double

fm=get(handles.fm,'string');
if isempty(fm) 
    return; 
end;

fm=str2num(fm);

if not(check_number(fm))   
    set(handles.fm,'string','');
    return;
end
 
if (fm>0.1 || fm<0)
                msgboxText{1} =  'Max. Doppler should range between 0 to 0.1.'; 
                msgbox(msgboxText,'Invalid Max. Doppler', 'warn');                
                set(handles.fm,'string',[]);
end;

    


% --- Executes during object creation, after setting all properties.
function fm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to fm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Clear_Table.
function Clear_Table_Callback(hObject, eventdata, handles)
% hObject    handle to Clear_Table (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global current_pos;
if (current_pos==0)
    msgboxText{1} =  'Nothing to remove.';
    msgbox(msgboxText,'Exception', 'warn');
    return;
end

reset_val={'' '' '' '' '' '' '' '' '' '' ;'' '' '' '' '' '' '' '' '' ''}';
set(handles.User_Table,'data',reset_val);
current_pos=0;

% --- Executes when entered data in editable cell(s) in user_input.
function user_input_CellEditCallback(hObject, eventdata, handles)
% hObject    handle to user_input (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) edited
%	PreviousData: previous data for the cell(s) edited
%	EditData: string(s) entered by the user
%	NewData: EditData or its converted form set on the Data property. Empty if Data was not changed
%	Error: error string when failed to convert EditData to appropriate value for Data
% handles    structure with handles and user data (see GUIDATA)
global insert_ok;

pos=eventdata.Indices;
read=get(handles.user_input,'data');

current_read=str2num(char(read(pos(2))));

if isempty(char(read(pos(2)))) || not(check_number (current_read))
    insert_ok(pos(2))=0;
    return;
end

switch pos(2)
    case(1)
        if (current_read<=0 || current_read>=1)
            insert_ok(pos(2))=0;
            msgboxText{1} =  'Delay should range between 0 to 1.';
            msgbox(msgboxText,'Invalid delay ', 'warn');
            return;
        end
    case (2)
        
        if (current_read<=0 || current_read>1)
            
            insert_ok(pos(2))=0;
            msgboxText{1} =  'Energy should range between 0 to 1.';
            msgbox(msgboxText,'Invalid energy value', 'warn');
            return;
        end
        
end

insert_ok(pos(2))=1;
guidata(hObject, handles);
return;



% --- Executes on button press in insert_row.
function insert_row_Callback(hObject, eventdata, handles)
% hObject    handle to insert_row (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global insert_ok;
global current_pos;

if (current_pos==10)
    msgboxText{1} =  'Maximum allowed value for K is 10.';
    msgbox(msgboxText,'Exception', 'warn');
    return;
end


if (current_pos>0)
    u_table=get(handles.User_Table,'data');
    for i=1:current_pos
        row=get(handles.user_input,'data');
        row=str2num(char(row(1)));
        prev=str2num(char(u_table(i,1)));
        if row==prev
            msgboxText{1} =  'Delays should be distinct.';
            msgbox(msgboxText,'Invalid delay', 'warn');
            return;
        end
    end
end


if (sum(insert_ok)==2)
    current_pos=current_pos+1;
    row=get(handles.user_input,'data');
    u_table=get(handles.User_Table,'data');
    u_table(current_pos,:)=row;
    set(handles.User_Table,'data',u_table);
    guidata(hObject, handles);
    return;
else
    msgboxText{1} =  'Invalid or insufficient input. Please correct it.';
    msgbox(msgboxText,'Invalid input', 'warn');
    return;
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over insert_row.
function insert_row_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to insert_row (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on key press with focus on insert_row and none of its controls.
function insert_row_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to insert_row (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)


% --- Executes when selected cell(s) is changed in user_input.
function user_input_CellSelectionCallback(hObject, eventdata, handles)
% hObject    handle to user_input (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) currently selecteds
% handles    structure with handles and user data (see GUIDATA)
            return;
            
guidata(hObject, handles);


% --------------------------------------------------------------------
function user_input_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to user_input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in order.
function order_Callback(hObject, eventdata, handles)
% hObject    handle to order (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns order contents as cell array
%        contents{get(hObject,'Value')} returns selected item from order


% --- Executes during object creation, after setting all properties.
function order_CreateFcn(hObject, eventdata, handles)
% hObject    handle to order (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --------------------------------------------------------------------
function User_Table_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to User_Table (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in Randomize.
function Randomize_Callback(hObject, eventdata, handles)
% hObject    handle to Randomize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
     
global current_pos;

rand_k=str2num(get(handles.rand_k,'String'));
if (isempty (rand_k) || rand_k==0)
    return;
end

data=get(handles.User_Table,'data');
k_rand=str2double(get(handles.rand_k,'string'));
current_pos=k_rand;
rand_values=rand(k_rand,2);

for i=1:10
    if i<=k_rand
        data(i,:)={num2str(rand_values(i,1)) num2str(rand_values(i,2))};
    else
        data(i,:)={'' ''};
    end
end
set(handles.User_Table,'data',data);


handles.output = hObject;
% Update handles structure
guidata(hObject, handles);


function rand_k_Callback(hObject, eventdata, handles)
% hObject    handle to rand_k (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of rand_k as text
%        str2double(get(hObject,'String')) returns contents of rand_k as a double

rand_k=str2num(get(hObject,'String'));
if not(check_number (rand_k))
    set(handles.rand_k,'string','');
    return;
end

if not(check_integer (rand_k))
    set(handles.rand_k,'string','');
    return;
end

if (rand_k>10 || rand_k<=0)
    msgboxText{1} =  'K should range between 1-10.';
    msgbox(msgboxText,'Invalid K.', 'warn');
    set(handles.rand_k,'string','');
    return;
end


% --- Executes during object creation, after setting all properties.
function rand_k_CreateFcn(hObject, eventdata, handles)
% hObject    handle to rand_k (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes when selected cell(s) is changed in User_Table.
function User_Table_CellSelectionCallback(hObject, eventdata, handles)
% hObject    handle to User_Table (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) currently selecteds
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in axes_k.
function axes_k_Callback(hObject, eventdata, handles)
% hObject    handle to axes_k (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns axes_k contents as cell array
%        contents{get(hObject,'Value')} returns selected item from axes_k
global h;
global Aout;
N=str2double(get(handles.N,'string'));
plot_seq(h,Aout,handles,N)




% --- Executes during object creation, after setting all properties.
function axes_k_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes_k (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in analog_axes_val.
function analog_axes_val_Callback(hObject, eventdata, handles)
% hObject    handle to analog_axes_val (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns analog_axes_val contents as cell array
%        contents{get(hObject,'Value')} returns selected item from analog_axes_val
global Cn;
plot_analog(Cn,handles);


% --- Executes during object creation, after setting all properties.
function analog_axes_val_CreateFcn(hObject, eventdata, handles)
% hObject    handle to analog_axes_val (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in seq_axes_val.
function seq_axes_val_Callback(hObject, eventdata, handles)
% hObject    handle to seq_axes_val (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns seq_axes_val contents as cell array
%        contents{get(hObject,'Value')} returns selected item from seq_axes_val
global h;
global Aout;
N=str2double(get(handles.N,'string'));
plot_seq(h,Aout,handles,N)

% --- Executes during object creation, after setting all properties.
function seq_axes_val_CreateFcn(hObject, eventdata, handles)
% hObject    handle to seq_axes_val (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in L2L.
function L2L_Callback(hObject, eventdata, handles)
% hObject    handle to L2L (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
AnalogAxes=handles.AnalogAxes;
cur_lim=xlim(AnalogAxes);
new_lim=[cur_lim(1)-0.1 cur_lim(2)];
set(handles.LLim,'String',num2str(new_lim(1)));
xlim(AnalogAxes,new_lim);


% --- Executes on button press in R2R.
function R2R_Callback(hObject, eventdata, handles)
% hObject    handle to R2R (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
AnalogAxes=handles.AnalogAxes;
cur_lim=xlim(AnalogAxes);
new_lim=[cur_lim(1) cur_lim(2)+0.1];
set(handles.RLim,'String',num2str(new_lim(2)));
xlim(AnalogAxes,new_lim);


% --- Executes on button press in L2R.
function L2R_Callback(hObject, eventdata, handles)
% hObject    handle to L2R (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
AnalogAxes=handles.AnalogAxes;
cur_lim=xlim(AnalogAxes);
new_lim=[cur_lim(1)+0.1 cur_lim(2)];
set(handles.LLim,'String',num2str(new_lim(1)));
xlim(AnalogAxes,new_lim);

% --- Executes on button press in R2L.
function R2L_Callback(hObject, eventdata, handles)
% hObject    handle to R2L (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
AnalogAxes=handles.AnalogAxes;
cur_lim=xlim(AnalogAxes);
new_lim=[cur_lim(1)  cur_lim(2)-0.1];
set(handles.RLim,'String',num2str(new_lim(2)));
xlim(AnalogAxes,new_lim);



function LLim_Callback(hObject, eventdata, handles)
% hObject    handle to LLim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of LLim as text
%        str2double(get(hObject,'String')) returns contents of LLim as a double

AnalogAxes=handles.AnalogAxes;
cur_lim=xlim(AnalogAxes);

LLim=get(hObject,'String');
LLim=str2num(LLim);

if ( isempty(LLim) || not(check_number(LLim)) || (LLim>=cur_lim(2)) )
    set(handles.LLim,'string',num2str(cur_lim(1)));
    return;
end

set(handles.AnalogAxes,'XLim',[LLim cur_lim(2)]);



% --- Executes during object creation, after setting all properties.
function LLim_CreateFcn(hObject, eventdata, handles)
% hObject    handle to LLim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function RLim_Callback(hObject, eventdata, handles)
% hObject    handle to RLim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RLim as text
%        str2double(get(hObject,'String')) returns contents of RLim as a double
AnalogAxes=handles.AnalogAxes;
cur_lim=xlim(AnalogAxes);

RLim=get(hObject,'String');

RLim=str2num(RLim);

if isempty(RLim) || not(check_number(RLim)) || (RLim<=cur_lim(1))
    set(handles.RLim,'string',num2str(cur_lim(2)));
    return;
end

set(handles.AnalogAxes,'XLim',[cur_lim(1) RLim]);


% --- Executes during object creation, after setting all properties.
function RLim_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RLim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in remove_last.
function remove_last_Callback(hObject, eventdata, handles)
% hObject    handle to remove_last (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global current_pos;
if (current_pos>0)
    data=get(handles.User_Table,'data');
    data(current_pos,:)={'' ''};
    set(handles.User_Table,'data',data);
    current_pos=current_pos-1;
else
    msgboxText{1} =  'Nothing to remove.';
    msgbox(msgboxText,'Exception', 'warn');
end

%%%%%%%%%%%%%%%%%%%%
% non-GUI functions%
%%%%%%%%%%%%%%%%%%%%


% checking the entered data before simulation
function data_ok=check_data(handles)
global current_pos;
p=get(handles.P,'string');
N=get(handles.N,'string');
SNR=get(handles.SNR,'string');
dist=get(handles.Gain_Seq,'value');
fm=get(handles.fm,'string');
f_type=get(handles.filter_type,'value');

if (isempty(p) || isempty(str2num(p)) || isempty(N) || isempty(num2str(N)) || isempty(SNR) || isempty(str2num(SNR)))
    msgboxText{1} =  'At least one of these values: Sequence length, SNR or p, is missing.'; 
    msgbox(msgboxText,'Missing data','warn');     
    data_ok=0;
    return;
end


if (dist>1)
    if isempty(fm) || isempty(str2num(fm))
        msgboxText{1} =  'Max. Doppler is missing.'; 
        msgbox(msgboxText,'Missing data','warn'); 
        data_ok=0;
        return;
    end
end

if (str2num(p)<=2*current_pos && f_type==2)
    msgboxText{1} =  ['When using Butterworth Filter, p should be greater than 2K and even.'] ; 
    msgbox(msgboxText,'Change p','warn');     
    data_ok=0;
    return;
end
   
    
if (str2num(p)<=current_pos)
    msgboxText{1} =  ['p should be greater than K and even.'] ; 
    msgbox(msgboxText,'Change p','warn');     
    data_ok=0;
    return;
end

data_ok=1;

% checking if a number is an integer
function is_int=check_integer(number)

if round(number)~=number
    msgboxText{1} =  'Non-integer number has been entered.'; 
    msgbox(msgboxText,'Input is not an integer', 'warn');    
    is_int=0;
    return;
   
end;
is_int=1;

% plotting the analog stage output

function plot_analog(Cn,handles) 

N=str2double(get(handles.N,'string'));
p=str2double(get(handles.P,'string'));
axes(handles.AnalogAxes);
cla reset;
hold off;
samples_dense=Cn(:);
samples_not_dense=Cn(1:10:end,:);
samples_not_dense=samples_not_dense(:);
val=get(handles.analog_axes_val,'Value');

switch (get(handles.filter_type,'value'))
    case(1)
        switch (val)
            case (1)
                plot(-1000:1/p/10:(1000+N)-1/p/10,abs(samples_dense)); hold on;
                plot(-1000:1/p:(1000+N)-1/p,abs(samples_not_dense),'.r');
                
            case (2)
                plot(-1000:1/p/10:(1000+N)-1/p/10,real(samples_dense)); hold on;
                plot(-1000:1/p:(1000+N)-1/p,real(samples_not_dense),'.r');
                
            case(3)
                plot(-1000:1/p/10:(1000+N)-1/p/10,imag(samples_dense)); hold on;
                plot(-1000:1/p:(1000+N)-1/p,imag(samples_not_dense),'.r');
        end
        LLim=get(handles.LLim,'String');
        RLim=get(handles.RLim,'String');
        LLim=str2num(LLim); RLim=str2num(RLim);
        xlim([LLim RLim]);
        
    case (2)
        switch (val)
            case (1)
                plot(0:1/p/10:(100+N)-1/p/10,abs(samples_dense)); hold on;
                plot(0:1/p:(100+N)-1/p,abs(samples_not_dense),'.r');
            case (2)
                plot(0:1/p/10:(100+N)-1/p/10,real(samples_dense)); hold on;
                plot(0:1/p:(100+N)-1/p,real(samples_not_dense),'.r');
            case (3)
                plot(0:1/p/10:(100+N)-1/p/10,imag(samples_dense)); hold on;
                plot(0:1/p:(100+N)-1/p,imag(samples_not_dense),'.r');
        end
        LLim=get(handles.LLim,'String');
        RLim=get(handles.RLim,'String');
        LLim=str2num(LLim); RLim=str2num(RLim);
        xlim([LLim RLim]);
        
        
end

hold on;
AL=legend('Analog Stage Output','Samples');
set(AL,'FontSize',8);
hold off;

% plotting delays and energies 

function plot_de(Aout,h,tk,N,handles)
global current_pos;
K=current_pos;

Aout_energy=zeros(K,1);
h_energy=zeros(K,1);
User_Table=get(handles.User_Table,'data');
Tau=str2num(char(User_Table(:,1)));

for i=1:K
    Aout_energy(i)=(1/N)*Aout(i,:)*Aout(i,:)';
    h_energy(i)=(1/N)*h(i,:)*h(i,:)';
end;

hold off;
axes(handles.DelaysAxes);cla reset;
stem(tk,Aout_energy);hold on;
stem(Tau,h_energy,'r--');
DL=legend('Channel','Estimated channel');
set(DL,'FontSize',8);
xlim([0 1]);
ylim([0 1]);
hold off;
    
 % plotting the sequence recovery 

function plot_seq(h,Aout,handles,N)

axes(handles.SeqAxes);cla reset;
no=get(handles.axes_k,'value');
val=get(handles.seq_axes_val,'Value');

switch val
    case (1)
        plot(1:N,abs(h(no,:))); hold on;
        plot(1:N,abs(Aout(no,:)),'r*');
    case (2)
        plot(1:N,real(h(no,:))); hold on;
        plot(1:N,real(Aout(no,:)),'r*');
    case (3)
        plot(1:N,imag(h(no,:))); hold on;
        plot(1:N,imag(Aout(no,:)),'r*');
end
SL=legend('Original','Recovered');
set(SL,'FontSize',8);
hold off;
  
%checking if an input is a number. if not, warning is displayed.
function is_num=check_number(input)
if isempty (input)
    msgboxText{1} =  'You entered something which is not a number. Please correct it.';
    msgbox(msgboxText,'Input is not a number', 'warn');
    is_num=0;
    return;
end
is_num=1;