function y=AnalogButter(t,w0,order)
% This function calculate the time response of a Butterworth analog 
% low-pass filter from order 3 to 10
% Written by Kfir Gedalyahu and Rami Cohen
%
% t - time vector
% w0 - filter's cuttoff frequency
% order - filter's order


x=w0.*t;

switch (order)
    case (3)
        AB=1./exp(x) - (cos((3^(1/2)*x)/2) - (3^(1/2)*sin((3^(1/2)*x)/2))/3)./exp(x/2);
    case (4)
        AB=(0.4619397662+1.115221249*1i)*exp((-0.9238795325-0.3826834324*1i)*x)+(.4619397662-1.115221249*1i)*exp((-.9238795325+.3826834324*1i)*x)+(-.4619397662-.1913417161*1i)*exp((-.3826834324-.9238795325*1i)*x)+(-.4619397662+.1913417161*1i)*exp((-.3826834324+.9238795325*1i)*x);
    case (5) 
        AB=(-.8090169944+1.113516364*1i)*exp((-.8090169944-.5877852523*1i)*x)+(-.8090169944-1.113516364*1i)*exp((-.8090169944+.5877852523*1i)*x)+(-.1381966011-.4253254042*1i)*exp((-.3090169944-.9510565163*1i)*x)+(-.1381966011+.4253254042*1i)*exp((-.3090169944+.9510565163*1i)*x)+1.894427191*exp(-1.*x);        
    case (6)        
        AB=(1.319479217+2.285405043*1i)*exp((-.9659258263-.2588190451*1i)*x)+(1.319479217-2.285405043*1i)*exp((-.9659258263+.2588190451*1i)*x)+(-1.523603362-0.*1i)*exp((-.7071067812-.7071067812*1i)*x)+(-1.523603362-0.*1i)*exp((-.7071067812+.7071067812*1i)*x)+(.2041241452-.3535533906*1i)*exp((-.2588190451-.9659258263*1i)*x)+(.2041241452+.3535533906*1i)*exp((-.2588190451+.9659258263*1i)*x);        
    case (7)        
        AB=4.311941111*exp(-x)+(-1.491977917+3.098124067*1i)*exp((-.9009688679-.4338837391*1i)*x)+(-1.491977917-3.098124067*1i)*exp((-.9009688679+.4338837391*1i)*x)+(-1.032480753-1.294689914*1i)*exp((-.6234898019-.7818314825*1i)*x)+(-1.032480753+1.294689914*1i)*exp((-.6234898019+.7818314825*1i)*x)+(.3684881145-0.8410500755e-1*1i)*exp((-.2225209340-.9749279122*1i)*x)+(.3684881145+0.8410500755e-1*1i)*exp((-.2225209340+.9749279122*1i)*x);        
    case (8)        
        AB=(3.567921473+5.339771837*1i)*exp((-.9807852804-.1950903220*1i)*x)+(3.567921473-5.339771837*1i)*exp((-.9807852804+.1950903220*1i)*x)+(-4.208650335+.8371526014*1i)*exp((-.8314696123-.5555702330*1i)*x)+(-4.208650335-.8371526014*1i)*exp((-.8314696123+.5555702330*1i)*x)+(.3467599613-1.743280048*1i)*exp((-.5555702330-.8314696123*1i)*x)+(.3467599613+1.743280048*1i)*exp((-.5555702330+.8314696123*1i)*x)+(.2939689006+.1964237396*1i)*exp((-.1950903220-.9807852804*1i)*x)+(.2939689006-.1964237396*1i)*exp((-.1950903220+.9807852804*1i)*x);        
    case (9)               
        AB=10.72114582*exp(-x)+(-3.076850664+8.453577723*1i)*exp((-.9396926208-.3420201433*1i)*x)+(-3.076850664-8.453577723*1i)*exp((-.9396926208+.3420201433*1i)*x)+(-3.978763018-3.338578581*1i)*exp((-.7660444431-.6427876097*1i)*x)+(-3.978763018+3.338578581*1i)*exp((-.7660444431+.6427876097*1i)*x)+(1.637158043-.9452136368*1i)*exp((-.5000000000-.8660254038*1i)*x)+(1.637158043+.9452136368*1i)*exp((-.5000000000+.8660254038*1i)*x)+(0.5788272587e-1+.3282692510*1i)*exp((-.1736481777-.9848077530*1i)*x)+(0.5788272587e-1-.3282692510*1i)*exp((-.1736481777+.9848077530*1i)*x);
    case (10)        
        AB=(9.756705827+13.42895351*1i)*exp((-.9876883406-.1564344650*1i)*x)+(9.756705827-13.42895351*1i)*exp((-.9876883406+.1564344650*1i)*x)+(-11.46969560+3.726730009*1i)*exp((-.8910065242-.4539904997*1i)*x)+(-11.46969560-3.726730009*1i)*exp((-.8910065242+.4539904997*1i)*x)+(1.351157786*10^(-12)-6.144852281*1i)*exp((-.7071067812-.7071067812*1i)*x)+(1.351157786*10^(-12)+6.144852281*1i)*exp((-.7071067812+.7071067812*1i)*x)+(1.898863783+.6169782435*1i)*exp((-.4539904997-.8910065242*1i)*x)+(1.898863783-.6169782435*1i)*exp((-.4539904997+.8910065242*1i)*x)+(-.1858740173+.2558336368*1i)*exp((-.1564344650-.9876883406*1i)*x)+(-.1858740173-.2558336368*1i)*exp((-.1564344650+.9876883406*1i)*x);
    otherwise
        error('PROBLEM: order should be between 3-10');
end

 y=w0*AB.*(t>=0);