clc;
%% constant SNR, 4 taps, 5 channels, rayliegh coefff
randn('state',0);
rand('state', 0);
close all;

T=1; % period;
Nsym=50; % number of symbols
ISI=1000; % kernel time length in T
SNR=22;

K=4; % number of deltas
p=5; % number of sampling sequences

tk=sort(T*rand(K,1));
%tk=[0.1 0.4 0.9 0.95]';
fm=0.05/T; % maximal doppler


% create channel coefficiants
chan = rayleighchan(1/T,fm);
h=zeros(K,Nsym);
for i=1:K
    x=ones(1,Nsym);
    h(i,:)=filter(chan,x);
    h(i,:)=(1/2)^(0.5*(i-1))*h(i,:)/std(h(i,:));
end
   
ak=[h zeros(K,2*ISI)];

% samples
C=zeros(p,size(ak,2));

for i=1:p
    for k=1:K
        DiscFilter=Phi(-ISI:ISI,tk(k),i-1,T,1/T);
        C(i,:)=C(i,:)+filter(DiscFilter,1,ak(k,:));
    end
end

Ec=sum(sum((abs(C(:,ISI+(1:Nsym))).^2)))/p/length(C(:,ISI+(1:Nsym))); % signal energy
n=10^(-SNR/20)*sqrt(Ec/2)*(randn(size(C))+j*randn(size(C))); % random noise with variance Ec
Cn=C+n;

% TLS ESPRIT
tk_esprit=TLS_ESPRIT(Cn(:,ISI+(1:Nsym)),K,T);

% sequences recovery
[Tk,M]=meshgrid(tk_esprit,0:p-1);
Ntau=exp(-j*2*pi/T*(M).*Tk);
A1=pinv(Ntau)*Cn;
Aout=zeros(size(A1));

n=-ISI:ISI;
for i=1:K
    DiscFilter=sinc(tk_esprit(i)+n*T).*exp(j*pi/T*(tk_esprit(i)+n*T));
    Aout(i,:)=filter(DiscFilter,1,A1(i,:));
end;

Aout=(Aout(:,2*ISI+(1:Nsym)));

figure;
stem(tk,var(h'),'fill','Markersize',6,'LineWidth',2);
hold on;
stem(tk_esprit,var(Aout'),'--sr','Markersize',6,'LineWidth',2);
xlabel('delay [T]','FontSize',14);
ylabel('tap energy','FontSize',14);
grid on;
leg=legend('channel','estimated channel');
set(leg,'FontSize',14);
title('Estimated time delays','FontSize',14);

figure;
plot(0:Nsym-1,real(h(1,1:Nsym)),'.','Markersize',6);
hold on;
plot(0:Nsym-1,real(Aout(1,1:Nsym)),'r*','Markersize',6);
xlabel('n','FontSize',14);
ylabel('magnitude','FontSize',14);
grid on;
leg=legend('original','recovered');
set(leg,'FontSize',14);
title('First path''s estimated time-varying gain coefficient','FontSize',14);

%% sampling demo
randn('state',0);
rand('state', 0);
close all;
clear all;

T=1; % period;
Nsym=4; % number of symbols
ISI=10; % kernel time length in T

K=2; % number of deltas
p=3; % number of sampling sequences

tk=T*[0.221 0.3210];
fm=0.05/T; % maximal doppler

over=100;

% create channel coefficiants
chan = rayleighchan(1/T,fm);
h=zeros(K,Nsym);
for i=1:K
    x=ones(1,Nsym);
    h(i,:)=real(filter(chan,x));
    h(i,:)=(1/2)^(0.5*(i-1))*h(i,:)/std(h(i,:));
end
   
ak=[zeros(K,ISI) rand(K,Nsym) zeros(K,2*ISI)];

% samples
C=zeros(p,size(ak,2));
Cover=zeros(p,over*size(ak,2));

for i=1:p
    for k=1:K
        DiscFilterOver=Phi(-ISI*over:ISI*over,tk(k),i-1,T/over,1/T);
        Cover(i,:)=Cover(i,:)+filter(DiscFilterOver,1,upsample(ak(k,:),over));
        
        DiscFilter=Phi(-ISI:ISI,tk(k),i-1,T,1/T);
        C(i,:)=C(i,:)+filter(DiscFilter,1,ak(k,:));
    end
end

C=C(:,ISI+1:end); % remove delay
Cover=Cover(:,(ISI*over)+1:end);


Tk=repmat(tk',1,Nsym+ISI*3)+T*repmat(0:Nsym+ISI*3-1,K,1);
Tk=Tk(:,1:Nsym+2*ISI);
ak=ak(:,1:Nsym+2*ISI);

td=0:T/over:T*(Nsym+ISI*2)-T/over;

figure;
stem(Tk(:)-ISI*T,ak(:),'^','fill','Markersize',6,'LineWidth',2);
xlim([-0.1 T*Nsym+0.1]);
xlabel('time [T]')
grid on;
title('Input signal','FontSize',12);

for i=1:2
    figure
    plot(td-ISI*T,real(Cover(i,:)),'LineWidth',2)
    hold on;
    stem(td(1:over:end)-ISI*T,real(C(i,:)),'--r','fill','MarkerSize',6,'LineWidth',2);
    xlim([-0.1 T*Nsym+0.1]);
    ylim([-2 2]);
    grid on;
    leg=legend('sampling filter output','samples');
    set(leg,'FontSize',14);
    xlabel('time[T]')
    if i==1
        title('First sampling channel','FontSize',12);
    elseif i==2
        title('Second sampling channel','FontSize',12);
    end
end

%% Varying SNR, 2 taps, 4 channels - complex BPFs
randn('state',0);
rand('state', 0);
close all;

tic;

K=2; % number of deltas
p=4; % number of sampling sequences

Avg=50;
SNR_Vec=-5:5:50;
MSE_BPF=zeros(1,length(SNR_Vec));
Error=zeros(K,length(SNR_Vec));

T=1; % period;
Nsym=100; % number of symbols
ISI=1000; % kernel time length in T

tk=T*[0.4362;  0.5210]; %[sort(T*rand(K,1));
%tk=T*[0.4362; 0.7210];
    
fm=0.05/T; % maximal doppler


% create channel coefficiants
chan = rayleighchan(1/T,fm);
h=zeros(K,Nsym);
for i=1:K
    x=ones(1,Nsym);
    h(i,:)=filter(chan,x);
end
    
h=randn(size(h));
ak=[h zeros(K,2*ISI)];

% samples
C=zeros(p,size(ak,2));

for i=1:p
    for k=1:K
        DiscFilter=Phi(-ISI:ISI,tk(k),i-1,T,1/T);
        C(i,:)=C(i,:)+filter(DiscFilter,1,ak(k,:));
    end
end

Ec=sum(sum((abs(C(:,ISI+(1:Nsym))).^2)))/p/Nsym; % signal energy


for snr_ind=1:length(SNR_Vec)
    for l=1:Avg
        
        n=10^(-SNR_Vec(snr_ind)/20)*sqrt(Ec/2)*(randn(size(C))+j*randn(size(C))); % random noise with variance Ec
        Cn=C+n;


        % TLS ESPRIT
        tk_esprit=TLS_ESPRIT(Cn(:,ISI+(1:Nsym)),K,T);
        %[Aout_bpf,tk_bpf]=ChanRecover(Cn,K,Nsym,100,'BPF');
        
        MSE_BPF(snr_ind)=MSE_BPF(snr_ind)+1/Avg/K*sum((tk-tk_esprit).^2);
        Error(:,snr_ind)=Error(:,snr_ind)+1/Avg*(tk_esprit-tk);

    end
end

%CRB Calc
tetak=2*pi/T*tk;

m=1:p;
k=1:K;

[Kvec,Mvec]=meshgrid(k,m);

A=exp(-j*tetak(Kvec).*(Mvec-1));
D=-exp(-j*tetak(Kvec).*(Mvec-1)).*(Mvec-1)*j;

temp=1/(2*Nsym)*inv(real((D'*(eye(p)-A*inv(A'*A)*A')*D).*eye(K)));
CRB=10*log10(temp(1))-SNR_Vec+20*log10(T/(2*pi))+3;

figure;
plot(SNR_Vec,10*log10(MSE_BPF));
hold on; plot(SNR_Vec,CRB,'r--');
xlabel('SNR [dB]');
ylabel('MSE [dB]');
legend('observed MSE','CRB');
grid on;
xlim([SNR_Vec(1) SNR_Vec(end)]);

%% Varying SNR, 2 taps, 4 channels - Ideal LPF
MSE_LPF=zeros(1,length(SNR_Vec));
ak=[h zeros(K,2*ISI)];
ISI_dig=200;
p=4;
% analog sampling proccess
C=zeros(p,size(ak,2));
n=-ISI:ISI;
for i=1:p
    for k=1:K
        delta=(i-1)*T/p;
        DiscFilter=sinc(p/T*(n*T+delta-tk(k)));
        C(i,:)=C(i,:)+filter(DiscFilter,1,ak(k,:));
    end
end

Ec=1/p/Nsym*sum(sum(abs(C(:,ISI+(1:Nsym))).^2));

for snr_ind=1:length(SNR_Vec)
    SNR=SNR_Vec(snr_ind);

    for avg_ind=1:Avg

        % noise adding
        n=10^(-SNR/20)*sqrt(Ec/2)*(randn(size(C))+j*randn(size(C))); % random noise with variance Ec
        Cn=C+n; % noisy samples

        % first digital correction
        D=[Cn zeros(p,2*ISI_dig)];
        n=-ISI_dig:ISI_dig;
        for i=1:p
            delta=(i-1)*T/p;
            DiscFilter=sinc(1/T*(+n*T-delta)).*exp(j*pi*n).*exp(j*pi/T*(p-1)*delta);
            D(i,:)=filter(DiscFilter,1,D(i,:));
        end

        Df=fft(D,[],1);
        % time recovery
        tk_esprit=TLS_ESPRIT(Df(:,ISI+ISI_dig+(1:Nsym)),K,T);
        MSE_LPF(snr_ind)= MSE_LPF(snr_ind)+1/Avg*1/K*sum(((tk_esprit-tk)/T).^2);
    end
end

figure;
plot(SNR_Vec,10*log10(MSE_LPF));
hold on; plot(SNR_Vec,CRB,'r--');
xlabel('SNR [dB]');
ylabel('MSE [dB]');
legend('observed MSE','CRB');
grid on;
xlim([SNR_Vec(1) SNR_Vec(end)]);

%% Varying SNR, 2 taps, 4 channels - Butter
%close all;
MSE_BT=zeros(1,length(SNR_Vec));
ak=[h zeros(K,ISI)];
ISI_dig=200;

order=5;
p=8;
att=10;
a=(att^2-1)^(1/6);
w0=(pi*p)/a/T; 

n=-ISI_dig:ISI_dig;
ButtCorFilter=zeros(p,length(n));
for i=1:p
    ButtCorFilter(i,:)=ButterCorrect(w0,order,-p/2+i,n);
end

% analog sampling proccess
C=zeros(p,size(ak,2));
n=0:ISI;
for i=1:p
    for k=1:K
        delta=(i-1)*T/p;
        DiscFilter=AnalogButter(n*T+delta-tk(k),w0,order);
        C(i,:)=C(i,:)+filter(DiscFilter,1,ak(k,:));
    end
end

Ec=1/4/Nsym*sum(sum(abs(C(:,(1:Nsym))).^2));

for snr_ind=1:length(SNR_Vec)
    SNR=SNR_Vec(snr_ind);

    for avg_ind=1:Avg

        % noise adding
        n=10^(-SNR/20)*sqrt(Ec/2)*(randn(size(C))+j*randn(size(C))); % random noise with variance Ec
        Cn=C+n; % noisy samples

        % first digital correction
        D=[Cn zeros(p,2*ISI_dig)];
        n=-ISI_dig:ISI_dig;
        for i=1:p
            delta=(i-1)*T/p;
            DiscFilter=sinc(1/T*(+n*T-delta)).*exp(j*pi*n).*exp(j*pi/T*(p-1)*delta);
            D(i,:)=filter(DiscFilter,1,D(i,:));
        end

        Df=fft(D);
        
        % second digital correction
        Df2=[Df zeros(p,2*ISI_dig)];
        for i=3:6%i=1:p
            Df2(i,:)=filter(ButtCorFilter(i,:),1,Df2(i,:));
        end
        
        % time recovery
        tk_esprit=TLS_ESPRIT(Df2(3:6,2*ISI_dig+(1:Nsym)),K,T);
        MSE_BT(snr_ind)= MSE_BT(snr_ind)+1/Avg*1/K*sum(((tk_esprit-tk)/T).^2);
    end
end

figure;
plot(SNR_Vec,10*log10(MSE_BT),'Linewidth',2.5);
hold on;
plot(SNR_Vec,10*log10(MSE_LPF),'g--','Linewidth',3);
plot(SNR_Vec,10*log10(MSE_BPF),'r:','Linewidth',3);
plot(SNR_Vec,CRB,'k-.','Linewidth',2.5);
xlabel('SNR [dB]','FontSize',14);
ylabel('MSE [dB]','FontSize',14);
leg=legend('Butterworth, p=8','ideal LPF, p=4','ideal BPFs, p=4','CRB');
set(leg,'FontSize',14);
grid on;
ylim([-100 -10]);
xlim([SNR_Vec(1) SNR_Vec(end)]);
toc;

