clc;
close all;
clear all;

%% constant SNR, 4 taps, 5 channels, rayliegh coefff
randn('state',0);
rand('state', 0);

T=1; % period;
N=50; % number of pulses
ISI=1000; % analog kernel delay [T]
DigDelay=200; % digital filters delay

SamplingKernel='BLPF';
order=6; % butterworth order
SNR=22;

K=4; % number of deltas
p=10; % number of sampling sequences

tk=sort(T*rand(K,1));
fm=0.05/T; % maximal doppler

% create channel coefficiants according to jakes model
chan = rayleighchan(1/T,fm);
h=zeros(K,N);
for i=1:K
    x=ones(1,N);
    h(i,:)=filter(chan,x);
    h(i,:)=(1/2)^(0.5*(i-1))*h(i,:)/std(h(i,:));
end

[Cn,C]=AnalogSampling(tk,p,h,SNR,SamplingKernel,order); % sampling
[Aout,tk_est]=ChanRecover(Cn,K,N,DigDelay,SamplingKernel,order); % channel's parameters recovery


figure;
stem(tk,var(h'),'fill','Markersize',6,'LineWidth',2);
hold on;
stem(tk_est,var(Aout'),'--sr','Markersize',6,'LineWidth',2);
xlabel('delay [T]','FontSize',12);
ylabel('tap energy','FontSize',12);
grid on;
leg=legend('channel','estimated channel');
set(leg,'FontSize',12);
title('Estimated time delays','FontSize',12);

figure;
plot(0:N-1,real(h(1,1:N)),'.','Markersize',6);
hold on;
plot(0:N-1,real(Aout(1,1:N)),'r*','Markersize',6);
xlabel('n','FontSize',12);
ylabel('magnitude','FontSize',12);
grid on;
leg=legend('original','recovered');
set(leg,'FontSize',12);
title('First path''s estimated time-varying gain coefficient','FontSize',12);


%% Varying SNR, 2 taps, 4 channels
randn('state',0);
rand('state', 0);

K=2; % number of deltas
p=4; % number of sampling sequences
T=1; % period;
N=100; % number of symbols

DigDelay=50;
order=6; % butterworth order

Avg=50; % number of experiments per SNR
SNR_Vec=-5:5:50; % SNR_Vec
MSE_BPF=zeros(1,length(SNR_Vec));
MSE_LPF=zeros(1,length(SNR_Vec));
MSE_BUTT=zeros(1,length(SNR_Vec));

tk=T*[0.4362;  0.5210];

% % create channel coefficiants
h=randn(K,N);

SNR=100;
[Cn,Cbpf]=AnalogSampling(tk,p,h,SNR,'BPF'); % sampling with BPF
[Cn,Clpf]=AnalogSampling(tk,p,h,SNR,'LPF'); % sampling with LPF
[Cn,Cbutt]=AnalogSampling(tk,p*2,h,SNR,'BLPF',order); % sampling with Butterworth, twice sampling rate

Ebpf=sum(sum((abs(Cbpf(:,ISI+(1:N))).^2)))/p/N; % signal energy
Elpf=sum(sum((abs(Clpf(:,ISI+(1:N))).^2)))/p/N; % signal energy
Ebutt=sum(sum((abs(Cbutt(:,(1:N))).^2)))/p/N; % signal energy

for snr_ind=1:length(SNR_Vec)
    for l=1:Avg
        
        % noise is added to the non-noisy samples
        n=10^(-SNR_Vec(snr_ind)/20)*sqrt(Ebpf/2)*(randn(size(Cbpf))+j*randn(size(Cbpf)));
        Cn=Cbpf+n;
        [Aout_bpf,tk_bpf]=ChanRecover(Cn,K,N,DigDelay,'BPF');

        n=10^(-SNR_Vec(snr_ind)/20)*sqrt(Elpf/2)*(randn(size(Clpf))+j*randn(size(Clpf)));
        Cn=Clpf+n;
        [Aout_lpf,tk_lpf]=ChanRecover(Cn,K,N,DigDelay,'LPF');

        n=10^(-SNR_Vec(snr_ind)/20)*sqrt(Ebutt/2)*(randn(size(Cbutt))+j*randn(size(Cbutt))); 
        Cn=Cbutt+n;
        [Aout_butt,tk_butt]=ChanRecover(Cn,K,N,DigDelay,'BLPF',order);

        MSE_BPF(snr_ind)=MSE_BPF(snr_ind)+1/Avg/K*sum((tk-tk_bpf).^2);
        MSE_LPF(snr_ind)=MSE_LPF(snr_ind)+1/Avg/K*sum((tk-tk_lpf).^2);
        MSE_BUTT(snr_ind)=MSE_BUTT(snr_ind)+1/Avg/K*sum((tk-tk_butt).^2);


    end
end

figure;
plot(SNR_Vec,10*log10(MSE_BUTT),'Linewidth',1.5);
hold on;
plot(SNR_Vec,10*log10(MSE_LPF),'g--','Linewidth',2);
plot(SNR_Vec,10*log10(MSE_BPF),'r:','Linewidth',2);
xlabel('SNR [dB]','FontSize',12);
ylabel('MSE [dB]','FontSize',12);
leg=legend('Butterworth, p=8','ideal LPF, p=4','ideal BPFs, p=4');
set(leg,'FontSize',12);
grid on;
ylim([-100 -10]);
xlim([SNR_Vec(1) SNR_Vec(end)]);


